/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.turf;

import ai.nextbillion.kits.geojson.Feature;
import ai.nextbillion.kits.geojson.FeatureCollection;
import ai.nextbillion.kits.geojson.Geometry;
import ai.nextbillion.kits.geojson.GeometryCollection;
import ai.nextbillion.kits.geojson.LineString;
import ai.nextbillion.kits.geojson.MultiLineString;
import ai.nextbillion.kits.geojson.MultiPoint;
import ai.nextbillion.kits.geojson.MultiPolygon;
import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.geojson.Polygon;
import ai.nextbillion.kits.turf.TurfException;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class TurfMeta {
    private TurfMeta() {
    }

    @NonNull
    public static List<Point> coordAll(@NonNull Point point) {
        return TurfMeta.coordAll(new ArrayList<Point>(), point);
    }

    @NonNull
    private static List<Point> coordAll(@NonNull List<Point> coords, @NonNull Point point) {
        coords.add(point);
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull MultiPoint multiPoint) {
        return TurfMeta.coordAll(new ArrayList<Point>(), multiPoint);
    }

    @NonNull
    private static List<Point> coordAll(@NonNull List<Point> coords, @NonNull MultiPoint multiPoint) {
        coords.addAll(multiPoint.coordinates());
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull LineString lineString) {
        return TurfMeta.coordAll(new ArrayList<Point>(), lineString);
    }

    @NonNull
    private static List<Point> coordAll(@NonNull List<Point> coords, @NonNull LineString lineString) {
        coords.addAll(lineString.coordinates());
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull Polygon polygon, @NonNull boolean excludeWrapCoord) {
        return TurfMeta.coordAll(new ArrayList<Point>(), polygon, excludeWrapCoord);
    }

    @NonNull
    private static List<Point> coordAll(@NonNull List<Point> coords, @NonNull Polygon polygon, @NonNull boolean excludeWrapCoord) {
        int wrapShrink = excludeWrapCoord ? 1 : 0;
        for (int i = 0; i < polygon.coordinates().size(); ++i) {
            for (int j = 0; j < ((List)polygon.coordinates().get(i)).size() - wrapShrink; ++j) {
                coords.add((Point)((List)polygon.coordinates().get(i)).get(j));
            }
        }
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull MultiLineString multiLineString) {
        return TurfMeta.coordAll(new ArrayList<Point>(), multiLineString);
    }

    @NonNull
    private static List<Point> coordAll(@NonNull List<Point> coords, @NonNull MultiLineString multiLineString) {
        for (int i = 0; i < multiLineString.coordinates().size(); ++i) {
            coords.addAll((Collection)multiLineString.coordinates().get(i));
        }
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull MultiPolygon multiPolygon, @NonNull boolean excludeWrapCoord) {
        return TurfMeta.coordAll(new ArrayList<Point>(), multiPolygon, excludeWrapCoord);
    }

    @NonNull
    private static List<Point> coordAll(@NonNull List<Point> coords, @NonNull MultiPolygon multiPolygon, @NonNull boolean excludeWrapCoord) {
        int wrapShrink = excludeWrapCoord ? 1 : 0;
        for (int i = 0; i < multiPolygon.coordinates().size(); ++i) {
            for (int j = 0; j < ((List)multiPolygon.coordinates().get(i)).size(); ++j) {
                for (int k = 0; k < ((List)((List)multiPolygon.coordinates().get(i)).get(j)).size() - wrapShrink; ++k) {
                    coords.add((Point)((List)((List)multiPolygon.coordinates().get(i)).get(j)).get(k));
                }
            }
        }
        return coords;
    }

    @NonNull
    public static List<Point> coordAll(@NonNull Feature feature, @NonNull boolean excludeWrapCoord) {
        return TurfMeta.addCoordAll(new ArrayList<Point>(), feature, excludeWrapCoord);
    }

    @NonNull
    public static List<Point> coordAll(@NonNull FeatureCollection featureCollection, @NonNull boolean excludeWrapCoord) {
        ArrayList<Point> finalCoordsList = new ArrayList<Point>();
        for (Feature singleFeature : featureCollection.features()) {
            TurfMeta.addCoordAll(finalCoordsList, singleFeature, excludeWrapCoord);
        }
        return finalCoordsList;
    }

    @NonNull
    private static List<Point> addCoordAll(@NonNull List<Point> pointList, @NonNull Feature feature, @NonNull boolean excludeWrapCoord) {
        return TurfMeta.coordAllFromSingleGeometry(pointList, feature.geometry(), excludeWrapCoord);
    }

    @NonNull
    private static List<Point> coordAllFromSingleGeometry(@NonNull List<Point> pointList, @NonNull Geometry geometry, @NonNull boolean excludeWrapCoord) {
        if (geometry instanceof Point) {
            pointList.add((Point)geometry);
        } else if (geometry instanceof MultiPoint) {
            pointList.addAll(((MultiPoint)geometry).coordinates());
        } else if (geometry instanceof LineString) {
            pointList.addAll(((LineString)geometry).coordinates());
        } else if (geometry instanceof MultiLineString) {
            TurfMeta.coordAll(pointList, (MultiLineString)geometry);
        } else if (geometry instanceof Polygon) {
            TurfMeta.coordAll(pointList, (Polygon)geometry, excludeWrapCoord);
        } else if (geometry instanceof MultiPolygon) {
            TurfMeta.coordAll(pointList, (MultiPolygon)geometry, excludeWrapCoord);
        } else if (geometry instanceof GeometryCollection) {
            for (Geometry singleGeometry : ((GeometryCollection)geometry).geometries()) {
                TurfMeta.coordAllFromSingleGeometry(pointList, singleGeometry, excludeWrapCoord);
            }
        }
        return pointList;
    }

    public static Point getCoord(Feature obj) {
        if (obj.geometry() instanceof Point) {
            return (Point)obj.geometry();
        }
        throw new TurfException("A Feature with a Point geometry is required.");
    }
}

