/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.turf;

import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.geojson.Polygon;
import ai.nextbillion.kits.turf.TurfConstants;
import ai.nextbillion.kits.turf.TurfMeasurement;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import java.util.ArrayList;

public final class TurfTransformation {
    private static final int DEFAULT_STEPS = 64;

    private TurfTransformation() {
    }

    public static Polygon circle(@NonNull Point center, double radius) {
        return TurfTransformation.circle(center, radius, 64, "kilometers");
    }

    public static Polygon circle(@NonNull Point center, double radius, @TurfConstants.TurfUnitCriteria String units) {
        return TurfTransformation.circle(center, radius, 64, units);
    }

    public static Polygon circle(@NonNull Point center, double radius, @IntRange(from=1L) int steps, @TurfConstants.TurfUnitCriteria String units) {
        ArrayList<Point> coordinates = new ArrayList<Point>();
        for (int i = 0; i < steps; ++i) {
            coordinates.add(TurfMeasurement.destination(center, radius, (double)i * 360.0 / (double)steps, units));
        }
        if (coordinates.size() > 0) {
            coordinates.add((Point)coordinates.get(0));
        }
        ArrayList<ArrayList<Point>> coordinate = new ArrayList<ArrayList<Point>>();
        coordinate.add(coordinates);
        return Polygon.fromLngLats(coordinate);
    }
}

