package ai.nextbillion.maps;

import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.DirectionsResult;
import ai.nextbillion.maps.model.DirectionsRoute;
import ai.nextbillion.maps.model.LatLng;

public class DirectionsApi {
  static final ApiConfig API_CONFIG = new ApiConfig("/directions/json");

  private DirectionsApi() {}

  public static DirectionsApiRequest newRequest(GeoApiContext context) {
    return new DirectionsApiRequest(context);
  }

  public static DirectionsApiRequest getDirections(
      GeoApiContext context, LatLng origin, LatLng destination) {
    return new DirectionsApiRequest(context).origin(origin).destination(destination);
  }

  public static class Response implements ApiResponse<DirectionsResult> {
    public String status;
    public String errorMessage;
    public DirectionsRoute[] routes;

    @Override
    public boolean successful() {
      return "Ok".equals(status) || "ZERO_RESULTS".equals(status);
    }

    @Override
    public DirectionsResult getResult() {
      DirectionsResult result = new DirectionsResult();
      result.routes = routes;
      return result;
    }

    @Override
    public ApiException getError() {
      if (successful()) {
        return null;
      }
      return ApiException.from(status, errorMessage);
    }
  }

  public enum RouteRestriction implements StringJoin.UrlValue {

    /** Indicates that the calculated route should avoid toll roads/bridges. */
    TOLLS("tolls"),

    /** Indicates that the calculated route should avoid highways. */
    HIGHWAYS("highways"),

    /** Indicates that the calculated route should avoid ferries. */
    FERRIES("ferries");

    private final String restriction;

    RouteRestriction(String restriction) {
      this.restriction = restriction;
    }

    @Override
    public String toString() {
      return restriction;
    }

    @Override
    public String toUrlValue() {
      return restriction;
    }
  }
}
