package ai.nextbillion.maps;

import ai.nextbillion.maps.model.*;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;

public class Main {
  public static void main(String[] args) throws Exception {
    GeoApiContext context =
        new GeoApiContext.Builder()
            .hostName("https://ola2.nextbillion.io")
            .apiKey("olatesting")
            .apiKeyInQuery(true)
            .build();

    Gson gson = new GsonBuilder().setPrettyPrinting().create();

    DirectionsResult results =
        DirectionsApi.getDirections(
                context, new LatLng(12.31784841, 76.63946369), new LatLng(12.30174779, 76.68237904))
            .steps(true)
            .await();

    System.out.println(gson.toJson(results));
  }
}
