package ai.nextbillion.maps.model;

import java.io.Serializable;

/**
 * A Directions API result. When the Directions API returns results, it places them within a routes
 * array. Even if the service returns no results (such as if the origin and/or destination doesn't
 * exist) it still returns an empty routes array.
 *
 * <p>Please see <a href="https://developers.google.com/maps/documentation/directions/intro#Routes">
 * Routes</a> for more detail.
 */
public class DirectionsRoute implements Serializable {

  private static final long serialVersionUID = 1L;

  public double distance;
  public double duration;
  public String geometry;
  public double predictedDuration;
  public double rawDuration;
  public LatLng startLocation;
  public LatLng endLocation;
  public DirectionsLeg[] legs;
}
