package ai.nextbillion.maps.model;

import java.io.Serializable;

/** A point that has been snapped to a road by the Roads API. */
public class SnappedPoint implements Serializable {

  private static final long serialVersionUID = 1L;
  /** A latitude/longitude value representing the snapped location. */
  public LatLng location;

  /**
   * The index of the corresponding value in the original request. Each value in the request should
   * map to a snapped value in the response. However, if you've set interpolate=true, then it's
   * possible that the response will contain more coordinates than the request. Interpolated values
   * will not have an originalIndex. These values are indexed from 0, so a point with an
   * originalIndex of 4 will be the snapped value of the 5th lat/lng passed to the path parameter.
   *
   * <p>A point that was not on the original path, or when interpolate=false, will have an
   * originalIndex of -1.
   */
  public int originalIndex = -1;

  @Override
  public String toString() {
    return String.format("[%s, originalIndex=%s]", location, originalIndex);
  }
}
