/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.DirectionsApiRequest;
import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.DirectionsResult;
import ai.nextbillion.maps.model.DirectionsRoute;
import ai.nextbillion.maps.model.LatLng;

public class DirectionsApi {
    static final ApiConfig API_CONFIG = new ApiConfig("/directions/json");

    private DirectionsApi() {
    }

    public static DirectionsApiRequest newRequest(GeoApiContext context) {
        return new DirectionsApiRequest(context);
    }

    public static DirectionsApiRequest getDirections(GeoApiContext context, LatLng origin, LatLng destination) {
        return new DirectionsApiRequest(context).origin(origin).destination(destination);
    }

    public static enum RouteRestriction implements StringJoin.UrlValue
    {
        TOLLS("tolls"),
        HIGHWAYS("highways"),
        FERRIES("ferries");

        private final String restriction;

        private RouteRestriction(String restriction) {
            this.restriction = restriction;
        }

        public String toString() {
            return this.restriction;
        }

        @Override
        public String toUrlValue() {
            return this.restriction;
        }
    }

    public static class Response
    implements ApiResponse<DirectionsResult> {
        public String status;
        public String errorMessage;
        public DirectionsRoute[] routes;

        @Override
        public boolean successful() {
            return "Ok".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public DirectionsResult getResult() {
            DirectionsResult result = new DirectionsResult();
            result.routes = this.routes;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

