/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.DistanceMatrixApiRequest;
import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.model.DistanceMatrix;
import ai.nextbillion.maps.model.DistanceMatrixRow;
import ai.nextbillion.maps.model.LatLng;

public class DistanceMatrixApi {
    static final ApiConfig API_CONFIG = new ApiConfig("/distancematrix/json");

    private DistanceMatrixApi() {
    }

    public static DistanceMatrixApiRequest newRequest(GeoApiContext context) {
        return new DistanceMatrixApiRequest(context);
    }

    public static DistanceMatrixApiRequest getDistanceMatrix(GeoApiContext context, LatLng[] origins, LatLng[] destinations) {
        return DistanceMatrixApi.newRequest(context).origins(origins).destinations(destinations);
    }

    public static class Response
    implements ApiResponse<DistanceMatrix> {
        public String status;
        public String errorMessage;
        public DistanceMatrixRow[] rows;

        @Override
        public boolean successful() {
            return "Ok".equals(this.status);
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }

        @Override
        public DistanceMatrix getResult() {
            return new DistanceMatrix(this.rows);
        }
    }
}

