/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.DirectionsApi;
import ai.nextbillion.maps.DistanceMatrixApi;
import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.DistanceMatrix;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.TrafficModel;
import ai.nextbillion.maps.model.TransitMode;
import ai.nextbillion.maps.model.TransitRoutingPreference;
import ai.nextbillion.maps.model.TravelMode;
import ai.nextbillion.maps.model.Unit;
import java.time.Instant;

public class DistanceMatrixApiRequest
extends PendingResultBase<DistanceMatrix, DistanceMatrixApiRequest, DistanceMatrixApi.Response> {
    public DistanceMatrixApiRequest(GeoApiContext context) {
        super(context, DistanceMatrixApi.API_CONFIG, DistanceMatrixApi.Response.class);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("origins")) {
            throw new IllegalArgumentException("Request must contain 'origins'");
        }
        if (!this.params().containsKey("destinations")) {
            throw new IllegalArgumentException("Request must contain 'destinations'");
        }
        if (this.params().containsKey("arrival_time") && this.params().containsKey("departure_time")) {
            throw new IllegalArgumentException("Transit request must not contain both a departureTime and an arrivalTime");
        }
    }

    public DistanceMatrixApiRequest origins(String ... origins) {
        return (DistanceMatrixApiRequest)this.param("origins", StringJoin.join('|', origins));
    }

    public DistanceMatrixApiRequest origins(LatLng ... points) {
        return (DistanceMatrixApiRequest)this.param("origins", StringJoin.join('|', points));
    }

    public DistanceMatrixApiRequest destinations(String ... destinations) {
        return (DistanceMatrixApiRequest)this.param("destinations", StringJoin.join('|', destinations));
    }

    public DistanceMatrixApiRequest destinations(LatLng ... points) {
        return (DistanceMatrixApiRequest)this.param("destinations", StringJoin.join('|', points));
    }

    public DistanceMatrixApiRequest mode(TravelMode mode) {
        if (TravelMode.DRIVING.equals(mode) || TravelMode.WALKING.equals(mode) || TravelMode.BICYCLING.equals(mode) || TravelMode.TRANSIT.equals(mode)) {
            return (DistanceMatrixApiRequest)this.param("mode", mode);
        }
        throw new IllegalArgumentException("Distance Matrix API travel modes must be Driving, Transit, Walking or Bicycling");
    }

    public DistanceMatrixApiRequest avoid(DirectionsApi.RouteRestriction restriction) {
        return (DistanceMatrixApiRequest)this.param("avoid", restriction);
    }

    public DistanceMatrixApiRequest units(Unit unit) {
        return (DistanceMatrixApiRequest)this.param("units", unit);
    }

    public DistanceMatrixApiRequest departureTime(Instant departureTime) {
        return (DistanceMatrixApiRequest)this.param("departure_time", Long.toString(departureTime.toEpochMilli() / 1000L));
    }

    public DistanceMatrixApiRequest trafficModel(TrafficModel trafficModel) {
        return (DistanceMatrixApiRequest)this.param("traffic_model", trafficModel);
    }

    public DistanceMatrixApiRequest arrivalTime(Instant arrivalTime) {
        return (DistanceMatrixApiRequest)this.param("arrival_time", Long.toString(arrivalTime.toEpochMilli() / 1000L));
    }

    public DistanceMatrixApiRequest transitModes(TransitMode ... transitModes) {
        return (DistanceMatrixApiRequest)this.param("transit_mode", StringJoin.join('|', transitModes));
    }

    public DistanceMatrixApiRequest transitRoutingPreference(TransitRoutingPreference pref) {
        return (DistanceMatrixApiRequest)this.param("transit_routing_preference", pref);
    }
}

