/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.FindPlaceFromText;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.PlacesSearchResult;
import com.google.gson.FieldNamingPolicy;

public class FindPlaceFromTextRequest
extends PendingResultBase<FindPlaceFromText, FindPlaceFromTextRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/findplacefromtext/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).supportsClientId(false);

    public FindPlaceFromTextRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public FindPlaceFromTextRequest input(String input) {
        return (FindPlaceFromTextRequest)this.param("input", input);
    }

    public FindPlaceFromTextRequest inputType(InputType inputType) {
        return (FindPlaceFromTextRequest)this.param("inputtype", inputType);
    }

    public FindPlaceFromTextRequest fields(FieldMask ... fields) {
        return (FindPlaceFromTextRequest)this.param("fields", StringJoin.join(',', fields));
    }

    public FindPlaceFromTextRequest locationBias(LocationBias locationBias) {
        return (FindPlaceFromTextRequest)this.param("locationbias", locationBias);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("input")) {
            throw new IllegalArgumentException("Request must contain 'input'.");
        }
        if (!this.params().containsKey("inputtype")) {
            throw new IllegalArgumentException("Request must contain 'inputType'.");
        }
    }

    public static class Response
    implements ApiResponse<FindPlaceFromText> {
        public String status;
        public PlacesSearchResult[] candidates;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public FindPlaceFromText getResult() {
            FindPlaceFromText result = new FindPlaceFromText();
            result.candidates = this.candidates;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }

    public static class LocationBiasRectangular
    implements LocationBias {
        private final LatLng southWest;
        private final LatLng northEast;

        public LocationBiasRectangular(LatLng southWest, LatLng northEast) {
            this.southWest = southWest;
            this.northEast = northEast;
        }

        @Override
        public String toUrlValue() {
            return "rectangle:" + this.southWest.toUrlValue() + "|" + this.northEast.toUrlValue();
        }
    }

    public static class LocationBiasCircular
    implements LocationBias {
        private final LatLng center;
        private final int radius;

        public LocationBiasCircular(LatLng center, int radius) {
            this.center = center;
            this.radius = radius;
        }

        @Override
        public String toUrlValue() {
            return "circle:" + this.radius + "@" + this.center.toUrlValue();
        }
    }

    public static class LocationBiasPoint
    implements LocationBias {
        private final LatLng point;

        public LocationBiasPoint(LatLng point) {
            this.point = point;
        }

        @Override
        public String toUrlValue() {
            return "point:" + this.point.toUrlValue();
        }
    }

    public static class LocationBiasIP
    implements LocationBias {
        @Override
        public String toUrlValue() {
            return "ipbias";
        }
    }

    public static interface LocationBias
    extends StringJoin.UrlValue {
    }

    public static enum FieldMask implements StringJoin.UrlValue
    {
        BUSINESS_STATUS("business_status"),
        FORMATTED_ADDRESS("formatted_address"),
        GEOMETRY("geometry"),
        ICON("icon"),
        ID("id"),
        NAME("name"),
        OPENING_HOURS("opening_hours"),
        PERMANENTLY_CLOSED("permanently_closed"),
        PHOTOS("photos"),
        PLACE_ID("place_id"),
        PRICE_LEVEL("price_level"),
        RATING("rating"),
        TYPES("types");

        private final String field;

        private FieldMask(String field) {
            this.field = field;
        }

        @Override
        public String toUrlValue() {
            return this.field;
        }
    }

    public static enum InputType implements StringJoin.UrlValue
    {
        TEXT_QUERY("textquery"),
        PHONE_NUMBER("phonenumber");

        private final String inputType;

        private InputType(String inputType) {
            this.inputType = inputType;
        }

        @Override
        public String toUrlValue() {
            return this.inputType;
        }
    }
}

