/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.GeocodingApi;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.AddressType;
import ai.nextbillion.maps.model.ComponentFilter;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.LocationType;

public class GeocodingApiRequest
extends PendingResultBase<String[], GeocodingApiRequest, GeocodingApi.Response> {
    private static final ApiConfig API_CONFIG = new ApiConfig("/geocode/json");

    public GeocodingApiRequest(GeoApiContext context) {
        super(context, API_CONFIG, GeocodingApi.Response.class);
    }

    @Override
    protected void validateRequest() {
        if (this.params().containsKey("latlng") && this.params().containsKey("address") && this.params().containsKey("place_id")) {
            throw new IllegalArgumentException("Request must contain only one of 'address', 'latlng' or 'place_id'.");
        }
        if (!(this.params().containsKey("coordinate") || this.params().containsKey("address") || this.params().containsKey("components") || this.params().containsKey("place_id"))) {
            throw new IllegalArgumentException("Request must contain at least one of 'address', 'latlng', 'place_id' and 'components'.");
        }
    }

    public GeocodingApiRequest address(String address) {
        return (GeocodingApiRequest)this.param("address", address);
    }

    public GeocodingApiRequest place(String placeId) {
        return (GeocodingApiRequest)this.param("place_id", placeId);
    }

    public GeocodingApiRequest latlng(LatLng latlng) {
        return (GeocodingApiRequest)this.param("coordinate", latlng);
    }

    public GeocodingApiRequest bounds(LatLng southWestBound, LatLng northEastBound) {
        return (GeocodingApiRequest)this.param("bounds", StringJoin.join('|', southWestBound, northEastBound));
    }

    public GeocodingApiRequest region(String region) {
        return (GeocodingApiRequest)this.param("region", region);
    }

    public GeocodingApiRequest components(ComponentFilter ... filters) {
        return (GeocodingApiRequest)this.param("components", StringJoin.join('|', filters));
    }

    public GeocodingApiRequest resultType(AddressType ... resultTypes) {
        return (GeocodingApiRequest)this.param("result_type", StringJoin.join('|', resultTypes));
    }

    public GeocodingApiRequest locationType(LocationType ... locationTypes) {
        return (GeocodingApiRequest)this.param("location_type", StringJoin.join('|', locationTypes));
    }
}

