/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.GeolocationApi;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.model.CellTower;
import ai.nextbillion.maps.model.GeolocationPayload;
import ai.nextbillion.maps.model.GeolocationResult;
import ai.nextbillion.maps.model.WifiAccessPoint;
import com.google.gson.Gson;

public class GeolocationApiRequest
extends PendingResultBase<GeolocationResult, GeolocationApiRequest, GeolocationApi.Response> {
    private GeolocationPayload payload = null;
    private GeolocationPayload.GeolocationPayloadBuilder builder = new GeolocationPayload.GeolocationPayloadBuilder();

    GeolocationApiRequest(GeoApiContext context) {
        super(context, GeolocationApi.GEOLOCATION_API_CONFIG, GeolocationApi.Response.class);
    }

    @Override
    protected void validateRequest() {
        if (this.payload.considerIp != null && !this.payload.considerIp.booleanValue() && this.payload.wifiAccessPoints != null && this.payload.wifiAccessPoints.length < 2) {
            throw new IllegalArgumentException("Request must contain two or more 'Wifi Access Points'");
        }
    }

    public GeolocationApiRequest HomeMobileCountryCode(int newHomeMobileCountryCode) {
        this.builder.HomeMobileCountryCode(newHomeMobileCountryCode);
        return this;
    }

    public GeolocationApiRequest HomeMobileNetworkCode(int newHomeMobileNetworkCode) {
        this.builder.HomeMobileNetworkCode(newHomeMobileNetworkCode);
        return this;
    }

    public GeolocationApiRequest RadioType(String newRadioType) {
        this.builder.RadioType(newRadioType);
        return this;
    }

    public GeolocationApiRequest Carrier(String newCarrier) {
        this.builder.Carrier(newCarrier);
        return this;
    }

    public GeolocationApiRequest ConsiderIp(boolean newConsiderIp) {
        this.builder.ConsiderIp(newConsiderIp);
        return this;
    }

    public GeolocationApiRequest CellTowers(CellTower[] newCellTowers) {
        this.builder.CellTowers(newCellTowers);
        return this;
    }

    public GeolocationApiRequest AddCellTower(CellTower newCellTower) {
        this.builder.AddCellTower(newCellTower);
        return this;
    }

    public GeolocationApiRequest WifiAccessPoints(WifiAccessPoint[] newWifiAccessPoints) {
        this.builder.WifiAccessPoints(newWifiAccessPoints);
        return this;
    }

    public GeolocationApiRequest AddWifiAccessPoint(WifiAccessPoint newWifiAccessPoint) {
        this.builder.AddWifiAccessPoint(newWifiAccessPoint);
        return this;
    }

    public GeolocationApiRequest Payload(GeolocationPayload payload) {
        this.payload = payload;
        return this;
    }

    public GeolocationApiRequest CreatePayload() {
        if (this.payload == null) {
            this.payload = this.builder.createGeolocationPayload();
        }
        Gson gson = new Gson();
        String jsonPayload = gson.toJson((Object)this.payload);
        return (GeolocationApiRequest)this.param("_payload", jsonPayload);
    }
}

