/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.PlaceType;
import ai.nextbillion.maps.model.PlacesSearchResponse;
import ai.nextbillion.maps.model.PlacesSearchResult;
import ai.nextbillion.maps.model.PriceLevel;
import ai.nextbillion.maps.model.RankBy;
import com.google.gson.FieldNamingPolicy;

public class NearbySearchRequest
extends PendingResultBase<PlacesSearchResponse, NearbySearchRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/nearbysearch/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    public NearbySearchRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public NearbySearchRequest location(LatLng location) {
        return (NearbySearchRequest)this.param("location", location);
    }

    public NearbySearchRequest radius(int distance) {
        if (distance > 50000) {
            throw new IllegalArgumentException("The maximum allowed radius is 50,000 meters.");
        }
        return (NearbySearchRequest)this.param("radius", String.valueOf(distance));
    }

    public NearbySearchRequest rankby(RankBy ranking) {
        return (NearbySearchRequest)this.param("rankby", ranking);
    }

    public NearbySearchRequest keyword(String keyword) {
        return (NearbySearchRequest)this.param("keyword", keyword);
    }

    public NearbySearchRequest minPrice(PriceLevel priceLevel) {
        return (NearbySearchRequest)this.param("minprice", priceLevel);
    }

    public NearbySearchRequest maxPrice(PriceLevel priceLevel) {
        return (NearbySearchRequest)this.param("maxprice", priceLevel);
    }

    public NearbySearchRequest name(String name) {
        return (NearbySearchRequest)this.param("name", name);
    }

    public NearbySearchRequest openNow(boolean openNow) {
        return (NearbySearchRequest)this.param("opennow", String.valueOf(openNow));
    }

    public NearbySearchRequest pageToken(String nextPageToken) {
        return (NearbySearchRequest)this.param("pagetoken", nextPageToken);
    }

    public NearbySearchRequest type(PlaceType type) {
        return (NearbySearchRequest)this.param("type", type);
    }

    @Deprecated
    public NearbySearchRequest type(PlaceType ... types) {
        return (NearbySearchRequest)this.param("type", StringJoin.join('|', types));
    }

    @Override
    protected void validateRequest() {
        if (this.params().containsKey("pagetoken")) {
            return;
        }
        if (this.params().containsKey("rankby") && this.params().get("rankby").get(0).equals(RankBy.DISTANCE.toString()) && this.params().containsKey("radius")) {
            throw new IllegalArgumentException("Request must not contain radius with rankby=distance");
        }
        if (this.params().containsKey("rankby") && this.params().get("rankby").get(0).equals(RankBy.DISTANCE.toString()) && !this.params().containsKey("keyword") && !this.params().containsKey("name") && !this.params().containsKey("type")) {
            throw new IllegalArgumentException("With rankby=distance is specified, then one or more of keyword, name, or type is required");
        }
    }

    public static class Response
    implements ApiResponse<PlacesSearchResponse> {
        public String status;
        public String[] htmlAttributions;
        public PlacesSearchResult[] results;
        public String nextPageToken;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public PlacesSearchResponse getResult() {
            PlacesSearchResponse result = new PlacesSearchResponse();
            result.htmlAttributions = this.htmlAttributions;
            result.results = this.results;
            result.nextPageToken = this.nextPageToken;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

