/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResult;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.ExceptionsAllowedToRetry;
import ai.nextbillion.maps.internal.OkHttpPendingResult;
import ai.nextbillion.maps.internal.RateLimitExecutorService;
import ai.nextbillion.maps.metrics.RequestMetrics;
import com.google.gson.FieldNamingPolicy;
import java.io.IOException;
import java.net.Proxy;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Dispatcher;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.Route;

public class OkHttpRequestHandler
implements GeoApiContext.RequestHandler {
    private static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    private final OkHttpClient client;
    private final ExecutorService executorService;
    private final String apiKey;
    private boolean apiKeyInQuery;

    OkHttpRequestHandler(OkHttpClient client, ExecutorService executorService, String apiKey, boolean apiKeyInQuery) {
        this.client = client;
        this.executorService = executorService;
        this.apiKey = apiKey;
        this.apiKeyInQuery = apiKeyInQuery;
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handle(String hostName, String url, String userAgent, String experienceIdHeaderValue, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry, RequestMetrics metrics) {
        Request.Builder builder = new Request.Builder().get().header("User-Agent", userAgent);
        if (this.apiKeyInQuery) {
            url = url.contains("?") ? url + "&key=" + this.apiKey : url + "?key=" + this.apiKey;
        } else {
            builder.header("Authorization", this.apiKey);
        }
        if (experienceIdHeaderValue != null) {
            builder = builder.header("X-Goog-Maps-Experience-ID", experienceIdHeaderValue);
        }
        Request req = builder.url(hostName + url).build();
        return new OkHttpPendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry, metrics);
    }

    @Override
    public <T, R extends ApiResponse<T>> PendingResult<T> handlePost(String hostName, String url, String payload, String userAgent, String experienceIdHeaderValue, Class<R> clazz, FieldNamingPolicy fieldNamingPolicy, long errorTimeout, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry, RequestMetrics metrics) {
        RequestBody body = RequestBody.create((MediaType)JSON, (String)payload);
        Request.Builder builder = new Request.Builder().post(body).header("User-Agent", userAgent);
        if (this.apiKeyInQuery) {
            url = url.contains("?") ? url + "&key=" + this.apiKey : url + "?key=" + this.apiKey;
        } else {
            builder.header("Authorization", this.apiKey);
        }
        if (experienceIdHeaderValue != null) {
            builder = builder.header("X-Goog-Maps-Experience-ID", experienceIdHeaderValue);
        }
        Request req = builder.url(hostName + url).build();
        return new OkHttpPendingResult(req, this.client, clazz, fieldNamingPolicy, errorTimeout, maxRetries, exceptionsAllowedToRetry, metrics);
    }

    @Override
    public void shutdown() {
        this.executorService.shutdown();
        this.client.connectionPool().evictAll();
    }

    public static class Builder
    implements GeoApiContext.RequestHandler.Builder {
        private final OkHttpClient.Builder builder = new OkHttpClient.Builder();
        private final RateLimitExecutorService rateLimitExecutorService = new RateLimitExecutorService();
        private final Dispatcher dispatcher = new Dispatcher((ExecutorService)this.rateLimitExecutorService);
        private String apiKey;
        private boolean apiKeyInQuery = false;

        public Builder() {
            this.builder.dispatcher(this.dispatcher);
        }

        @Override
        public Builder connectTimeout(long timeout, TimeUnit unit) {
            this.builder.connectTimeout(timeout, unit);
            return this;
        }

        @Override
        public Builder readTimeout(long timeout, TimeUnit unit) {
            this.builder.readTimeout(timeout, unit);
            return this;
        }

        @Override
        public Builder writeTimeout(long timeout, TimeUnit unit) {
            this.builder.writeTimeout(timeout, unit);
            return this;
        }

        @Override
        public Builder queriesPerSecond(int maxQps) {
            this.dispatcher.setMaxRequests(maxQps);
            this.dispatcher.setMaxRequestsPerHost(maxQps);
            this.rateLimitExecutorService.setQueriesPerSecond(maxQps);
            return this;
        }

        @Override
        public Builder proxy(Proxy proxy) {
            this.builder.proxy(proxy);
            return this;
        }

        @Override
        public Builder proxyAuthentication(String proxyUserName, String proxyUserPassword) {
            final String userName = proxyUserName;
            final String password = proxyUserPassword;
            this.builder.proxyAuthenticator(new Authenticator(){

                public Request authenticate(Route route, Response response) throws IOException {
                    String credential = Credentials.basic((String)userName, (String)password);
                    return response.request().newBuilder().header("Proxy-Authorization", credential).build();
                }
            });
            return this;
        }

        @Override
        public GeoApiContext.RequestHandler.Builder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        @Override
        public GeoApiContext.RequestHandler.Builder apiKeyInQuery(boolean apiKeyInQuery) {
            this.apiKeyInQuery = apiKeyInQuery;
            return this;
        }

        public OkHttpClient.Builder okHttpClientBuilder() {
            return this.builder;
        }

        @Override
        public GeoApiContext.RequestHandler build() {
            OkHttpClient client = this.builder.build();
            return new OkHttpRequestHandler(client, this.rateLimitExecutorService, this.apiKey, this.apiKeyInQuery);
        }
    }
}

