/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResult;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.StringJoin;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

abstract class PendingResultBase<T, A extends PendingResultBase<T, A, R>, R extends ApiResponse<T>>
implements PendingResult<T> {
    private final GeoApiContext context;
    private final ApiConfig config;
    private final HashMap<String, List<String>> params = new HashMap();
    private PendingResult<T> delegate;
    private final Class<? extends R> responseClass;

    protected PendingResultBase(GeoApiContext context, ApiConfig config, Class<? extends R> clazz) {
        this.context = context;
        this.config = config;
        this.responseClass = clazz;
    }

    @Override
    public final void setCallback(PendingResult.Callback<T> callback) {
        this.makeRequest().setCallback(callback);
    }

    @Override
    public final T await() throws ApiException, InterruptedException, IOException {
        PendingResult<T> request = this.makeRequest();
        return request.await();
    }

    @Override
    public final T awaitIgnoreError() {
        return this.makeRequest().awaitIgnoreError();
    }

    @Override
    public final void cancel() {
        if (this.delegate == null) {
            return;
        }
        this.delegate.cancel();
    }

    private PendingResult<T> makeRequest() {
        if (this.delegate != null) {
            throw new IllegalStateException("'await', 'awaitIgnoreError' or 'setCallback' was already called.");
        }
        this.validateRequest();
        switch (this.config.requestVerb) {
            case "GET": {
                this.delegate = this.context.get(this.config, this.responseClass, this.params);
                return this.delegate;
            }
            case "POST": {
                this.delegate = this.context.post(this.config, this.responseClass, this.params);
                return this.delegate;
            }
        }
        throw new IllegalStateException(String.format("Unexpected request method '%s'", this.config.requestVerb));
    }

    protected abstract void validateRequest();

    private A getInstance() {
        PendingResultBase result = this;
        return (A)result;
    }

    protected A param(String key, String val) {
        this.params.put(key, new ArrayList());
        return this.paramAddToList(key, val);
    }

    protected A param(String key, int val) {
        return this.param(key, Integer.toString(val));
    }

    protected A param(String key, StringJoin.UrlValue val) {
        if (val != null) {
            return this.param(key, val.toUrlValue());
        }
        return this.getInstance();
    }

    protected A paramAddToList(String key, String val) {
        if (this.params.get(key) == null) {
            this.params.put(key, new ArrayList());
        }
        this.params.get(key).add(val);
        return this.getInstance();
    }

    protected A paramAddToList(String key, StringJoin.UrlValue val) {
        if (val != null) {
            return this.paramAddToList(key, val.toUrlValue());
        }
        return this.getInstance();
    }

    protected Map<String, List<String>> params() {
        return Collections.unmodifiableMap(this.params);
    }

    public final A language(String language) {
        return this.param("language", language);
    }

    public A channel(String channel) {
        return this.param("channel", channel);
    }

    public A custom(String parameter, String value) {
        return this.param(parameter, value);
    }
}

