/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.AutocompletePrediction;
import ai.nextbillion.maps.model.ComponentFilter;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.PlaceAutocompleteType;
import com.google.gson.FieldNamingPolicy;
import java.io.Serializable;
import java.util.UUID;

public class PlaceAutocompleteRequest
extends PendingResultBase<AutocompletePrediction[], PlaceAutocompleteRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/autocomplete/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    protected PlaceAutocompleteRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public PlaceAutocompleteRequest sessionToken(SessionToken sessionToken) {
        return (PlaceAutocompleteRequest)this.param("sessiontoken", sessionToken);
    }

    public PlaceAutocompleteRequest input(String input) {
        return (PlaceAutocompleteRequest)this.param("input", input);
    }

    public PlaceAutocompleteRequest offset(int offset) {
        return (PlaceAutocompleteRequest)this.param("offset", String.valueOf(offset));
    }

    public PlaceAutocompleteRequest origin(LatLng origin) {
        return (PlaceAutocompleteRequest)this.param("origin", origin);
    }

    public PlaceAutocompleteRequest location(LatLng location) {
        return (PlaceAutocompleteRequest)this.param("location", location);
    }

    public PlaceAutocompleteRequest radius(int radius) {
        return (PlaceAutocompleteRequest)this.param("radius", String.valueOf(radius));
    }

    public PlaceAutocompleteRequest type(PlaceAutocompleteType type) {
        return this.types(type);
    }

    public PlaceAutocompleteRequest types(PlaceAutocompleteType types) {
        return (PlaceAutocompleteRequest)this.param("types", types);
    }

    public PlaceAutocompleteRequest components(ComponentFilter ... filters) {
        return (PlaceAutocompleteRequest)this.param("components", StringJoin.join('|', filters));
    }

    public PlaceAutocompleteRequest strictBounds(boolean strictBounds) {
        return (PlaceAutocompleteRequest)this.param("strictbounds", Boolean.toString(strictBounds));
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("input")) {
            throw new IllegalArgumentException("Request must contain 'input'.");
        }
    }

    public static class Response
    implements ApiResponse<AutocompletePrediction[]> {
        public String status;
        public AutocompletePrediction[] predictions;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public AutocompletePrediction[] getResult() {
            return this.predictions;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }

    public static final class SessionToken
    implements StringJoin.UrlValue,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final UUID uuid;

        public SessionToken() {
            this.uuid = UUID.randomUUID();
        }

        public SessionToken(UUID uuid) {
            this.uuid = uuid;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public String toUrlValue() {
            return this.uuid.toString();
        }
    }
}

