/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.model.AutocompletePrediction;
import ai.nextbillion.maps.model.LatLng;
import com.google.gson.FieldNamingPolicy;

public class QueryAutocompleteRequest
extends PendingResultBase<AutocompletePrediction[], QueryAutocompleteRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/queryautocomplete/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    protected QueryAutocompleteRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    @Override
    protected void validateRequest() {
        if (!this.params().containsKey("input")) {
            throw new IllegalArgumentException("Request must contain 'input'.");
        }
    }

    public QueryAutocompleteRequest input(String input) {
        return (QueryAutocompleteRequest)this.param("input", input);
    }

    public QueryAutocompleteRequest offset(int offset) {
        return (QueryAutocompleteRequest)this.param("offset", String.valueOf(offset));
    }

    public QueryAutocompleteRequest location(LatLng location) {
        return (QueryAutocompleteRequest)this.param("location", location);
    }

    public QueryAutocompleteRequest radius(int radius) {
        return (QueryAutocompleteRequest)this.param("radius", String.valueOf(radius));
    }

    public static class Response
    implements ApiResponse<AutocompletePrediction[]> {
        public String status;
        public AutocompletePrediction[] predictions;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public AutocompletePrediction[] getResult() {
            return this.predictions;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

