/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResult;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.StringJoin;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.SnappedPoint;
import com.google.gson.FieldNamingPolicy;

public class RoadsApi {
    static final ApiConfig SNAP_TO_ROADS_API_CONFIG = new ApiConfig("/snapToRoads/json").fieldNamingPolicy(FieldNamingPolicy.IDENTITY);

    private RoadsApi() {
    }

    public static PendingResult<SnappedPoint[]> snapToRoads(GeoApiContext context, LatLng ... path) {
        return context.get(SNAP_TO_ROADS_API_CONFIG, RoadsResponse.class, "path", StringJoin.join('|', path));
    }

    public static class RoadsResponse
    implements ApiResponse<SnappedPoint[]> {
        public String status;
        public SnappedPoint[] snappedPoints;
        public double distance;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "Ok".equals(this.status);
        }

        @Override
        public SnappedPoint[] getResult() {
            return this.snappedPoints;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

