/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps;

import ai.nextbillion.maps.GeoApiContext;
import ai.nextbillion.maps.PendingResultBase;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.internal.ApiConfig;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.PlaceType;
import ai.nextbillion.maps.model.PlacesSearchResponse;
import ai.nextbillion.maps.model.PlacesSearchResult;
import ai.nextbillion.maps.model.PriceLevel;
import ai.nextbillion.maps.model.RankBy;
import com.google.gson.FieldNamingPolicy;

public class TextSearchRequest
extends PendingResultBase<PlacesSearchResponse, TextSearchRequest, Response> {
    static final ApiConfig API_CONFIG = new ApiConfig("/maps/api/place/textsearch/json").fieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES);

    public TextSearchRequest(GeoApiContext context) {
        super(context, API_CONFIG, Response.class);
    }

    public TextSearchRequest query(String query) {
        return (TextSearchRequest)this.param("query", query);
    }

    public TextSearchRequest location(LatLng location) {
        return (TextSearchRequest)this.param("location", location);
    }

    public TextSearchRequest region(String region) {
        return (TextSearchRequest)this.param("region", region);
    }

    public TextSearchRequest radius(int radius) {
        if (radius > 50000) {
            throw new IllegalArgumentException("The maximum allowed radius is 50,000 meters.");
        }
        return (TextSearchRequest)this.param("radius", String.valueOf(radius));
    }

    public TextSearchRequest minPrice(PriceLevel priceLevel) {
        return (TextSearchRequest)this.param("minprice", priceLevel);
    }

    public TextSearchRequest maxPrice(PriceLevel priceLevel) {
        return (TextSearchRequest)this.param("maxprice", priceLevel);
    }

    public TextSearchRequest name(String name) {
        return (TextSearchRequest)this.param("name", name);
    }

    public TextSearchRequest openNow(boolean openNow) {
        return (TextSearchRequest)this.param("opennow", String.valueOf(openNow));
    }

    public TextSearchRequest pageToken(String nextPageToken) {
        return (TextSearchRequest)this.param("pagetoken", nextPageToken);
    }

    public TextSearchRequest rankby(RankBy ranking) {
        return (TextSearchRequest)this.param("rankby", ranking);
    }

    public TextSearchRequest type(PlaceType type) {
        return (TextSearchRequest)this.param("type", type);
    }

    @Override
    protected void validateRequest() {
        if (this.params().containsKey("pagetoken")) {
            return;
        }
        if (!this.params().containsKey("query") && !this.params().containsKey("type")) {
            throw new IllegalArgumentException("Request must contain 'query' or a 'pageToken'. If a 'type' is specified 'query' becomes optional.");
        }
        if (this.params().containsKey("location") && !this.params().containsKey("radius")) {
            throw new IllegalArgumentException("Request must contain 'radius' parameter when it contains a 'location' parameter.");
        }
    }

    public static class Response
    implements ApiResponse<PlacesSearchResponse> {
        public String status;
        public String[] htmlAttributions;
        public PlacesSearchResult[] results;
        public String nextPageToken;
        public String errorMessage;

        @Override
        public boolean successful() {
            return "OK".equals(this.status) || "ZERO_RESULTS".equals(this.status);
        }

        @Override
        public PlacesSearchResponse getResult() {
            PlacesSearchResponse result = new PlacesSearchResponse();
            result.htmlAttributions = this.htmlAttributions;
            result.results = this.results;
            result.nextPageToken = this.nextPageToken;
            return result;
        }

        @Override
        public ApiException getError() {
            if (this.successful()) {
                return null;
            }
            return ApiException.from(this.status, this.errorMessage);
        }
    }
}

