/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps.errors;

import ai.nextbillion.maps.errors.AccessNotConfiguredException;
import ai.nextbillion.maps.errors.InvalidRequestException;
import ai.nextbillion.maps.errors.MaxElementsExceededException;
import ai.nextbillion.maps.errors.MaxRouteLengthExceededException;
import ai.nextbillion.maps.errors.MaxWaypointsExceededException;
import ai.nextbillion.maps.errors.NotFoundException;
import ai.nextbillion.maps.errors.OverDailyLimitException;
import ai.nextbillion.maps.errors.OverQueryLimitException;
import ai.nextbillion.maps.errors.RequestDeniedException;
import ai.nextbillion.maps.errors.UnknownErrorException;
import ai.nextbillion.maps.errors.ZeroResultsException;

public class ApiException
extends Exception {
    private static final long serialVersionUID = -6550606366694345191L;

    protected ApiException(String message) {
        super(message);
    }

    public static ApiException from(String status, String errorMessage) {
        if ("OK".equals(status)) {
            return null;
        }
        if ("INVALID_REQUEST".equals(status)) {
            return new InvalidRequestException(errorMessage);
        }
        if ("MAX_ELEMENTS_EXCEEDED".equals(status)) {
            return new MaxElementsExceededException(errorMessage);
        }
        if ("MAX_ROUTE_LENGTH_EXCEEDED".equals(status)) {
            return new MaxRouteLengthExceededException(errorMessage);
        }
        if ("MAX_WAYPOINTS_EXCEEDED".equals(status)) {
            return new MaxWaypointsExceededException(errorMessage);
        }
        if ("NOT_FOUND".equals(status)) {
            return new NotFoundException(errorMessage);
        }
        if ("OVER_QUERY_LIMIT".equals(status)) {
            if ("You have exceeded your daily request quota for this API.".equalsIgnoreCase(errorMessage)) {
                return new OverDailyLimitException(errorMessage);
            }
            return new OverQueryLimitException(errorMessage);
        }
        if ("REQUEST_DENIED".equals(status)) {
            return new RequestDeniedException(errorMessage);
        }
        if ("UNKNOWN_ERROR".equals(status)) {
            return new UnknownErrorException(errorMessage);
        }
        if ("ZERO_RESULTS".equals(status)) {
            return new ZeroResultsException(errorMessage);
        }
        if ("ACCESS_NOT_CONFIGURED".equals(status)) {
            return new AccessNotConfiguredException(errorMessage);
        }
        if ("INVALID_ARGUMENT".equals(status)) {
            return new InvalidRequestException(errorMessage);
        }
        if ("RESOURCE_EXHAUSTED".equals(status)) {
            return new OverQueryLimitException(errorMessage);
        }
        if ("PERMISSION_DENIED".equals(status)) {
            return new RequestDeniedException(errorMessage);
        }
        if ("keyInvalid".equals(status)) {
            return new AccessNotConfiguredException(errorMessage);
        }
        if ("dailyLimitExceeded".equals(status)) {
            return new OverDailyLimitException(errorMessage);
        }
        if ("userRateLimitExceeded".equals(status)) {
            return new OverQueryLimitException(errorMessage);
        }
        if ("notFound".equals(status)) {
            return new NotFoundException(errorMessage);
        }
        if ("parseError".equals(status)) {
            return new InvalidRequestException(errorMessage);
        }
        if ("invalid".equals(status)) {
            return new InvalidRequestException(errorMessage);
        }
        return new UnknownErrorException("An unexpected error occurred. Status: " + status + ", Message: " + errorMessage);
    }
}

