/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps.internal;

import ai.nextbillion.maps.GeolocationApi;
import ai.nextbillion.maps.ImageResult;
import ai.nextbillion.maps.PendingResult;
import ai.nextbillion.maps.errors.ApiException;
import ai.nextbillion.maps.errors.UnknownErrorException;
import ai.nextbillion.maps.internal.ApiResponse;
import ai.nextbillion.maps.internal.DayOfWeekAdapter;
import ai.nextbillion.maps.internal.DistanceAdapter;
import ai.nextbillion.maps.internal.DurationAdapter;
import ai.nextbillion.maps.internal.EncodedPolylineInstanceCreator;
import ai.nextbillion.maps.internal.ExceptionsAllowedToRetry;
import ai.nextbillion.maps.internal.FareAdapter;
import ai.nextbillion.maps.internal.GeolocationResponseAdapter;
import ai.nextbillion.maps.internal.InstantAdapter;
import ai.nextbillion.maps.internal.LatLngAdapter;
import ai.nextbillion.maps.internal.LocalTimeAdapter;
import ai.nextbillion.maps.internal.PriceLevelAdapter;
import ai.nextbillion.maps.internal.SafeEnumAdapter;
import ai.nextbillion.maps.internal.ZonedDateTimeAdapter;
import ai.nextbillion.maps.metrics.RequestMetrics;
import ai.nextbillion.maps.model.AddressComponentType;
import ai.nextbillion.maps.model.AddressType;
import ai.nextbillion.maps.model.Distance;
import ai.nextbillion.maps.model.Duration;
import ai.nextbillion.maps.model.EncodedPolyline;
import ai.nextbillion.maps.model.Fare;
import ai.nextbillion.maps.model.LatLng;
import ai.nextbillion.maps.model.LocationType;
import ai.nextbillion.maps.model.OpeningHours;
import ai.nextbillion.maps.model.PlaceDetails;
import ai.nextbillion.maps.model.PriceLevel;
import ai.nextbillion.maps.model.TravelMode;
import com.google.appengine.api.urlfetch.HTTPHeader;
import com.google.appengine.api.urlfetch.HTTPRequest;
import com.google.appengine.api.urlfetch.HTTPResponse;
import com.google.appengine.api.urlfetch.URLFetchService;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GaePendingResult<T, R extends ApiResponse<T>>
implements PendingResult<T> {
    private final HTTPRequest request;
    private final URLFetchService client;
    private final Class<R> responseClass;
    private final FieldNamingPolicy fieldNamingPolicy;
    private final Integer maxRetries;
    private final ExceptionsAllowedToRetry exceptionsAllowedToRetry;
    private final RequestMetrics metrics;
    private final long errorTimeOut;
    private int retryCounter = 0;
    private final long cumulativeSleepTime = 0L;
    private Future<HTTPResponse> call;
    private static final Logger LOG = LoggerFactory.getLogger((String)GaePendingResult.class.getName());
    private static final List<Integer> RETRY_ERROR_CODES = Arrays.asList(500, 503, 504);

    public GaePendingResult(HTTPRequest request, URLFetchService client, Class<R> responseClass, FieldNamingPolicy fieldNamingPolicy, long errorTimeOut, Integer maxRetries, ExceptionsAllowedToRetry exceptionsAllowedToRetry, RequestMetrics metrics) {
        this.request = request;
        this.client = client;
        this.responseClass = responseClass;
        this.fieldNamingPolicy = fieldNamingPolicy;
        this.errorTimeOut = errorTimeOut;
        this.maxRetries = maxRetries;
        this.exceptionsAllowedToRetry = exceptionsAllowedToRetry;
        this.metrics = metrics;
        metrics.startNetwork();
        this.call = client.fetchAsync(request);
    }

    @Override
    public void setCallback(PendingResult.Callback<T> callback) {
        throw new RuntimeException("setCallback not implemented for Google App Engine");
    }

    @Override
    public T await() throws ApiException, IOException, InterruptedException {
        try {
            HTTPResponse result = this.call.get();
            this.metrics.endNetwork();
            return this.parseResponse(this, result);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw new UnknownErrorException("Unexpected exception from " + e.getMessage());
        }
    }

    @Override
    public T awaitIgnoreError() {
        try {
            return this.await();
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void cancel() {
        this.call.cancel(true);
    }

    private T parseResponse(GaePendingResult<T, R> request, HTTPResponse response) throws IOException, ApiException, InterruptedException {
        try {
            T result = this.parseResponseInternal(request, response);
            this.metrics.endRequest(null, response.getResponseCode(), this.retryCounter);
            return result;
        }
        catch (Exception e) {
            this.metrics.endRequest(e, response.getResponseCode(), this.retryCounter);
            throw e;
        }
    }

    private T parseResponseInternal(GaePendingResult<T, R> request, HTTPResponse response) throws IOException, ApiException, InterruptedException {
        ApiResponse resp;
        if (this.shouldRetry(response)) {
            return super.retry();
        }
        byte[] bytes = response.getContent();
        String contentType = null;
        for (HTTPHeader header : response.getHeaders()) {
            if (!header.getName().equalsIgnoreCase("Content-Type")) continue;
            contentType = header.getValue();
        }
        if (contentType != null && contentType.startsWith("image") && this.responseClass == ImageResult.Response.class && response.getResponseCode() == 200) {
            ImageResult result = new ImageResult(contentType, bytes);
            return (T)result;
        }
        Gson gson = new GsonBuilder().registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).registerTypeAdapter(Distance.class, (Object)new DistanceAdapter()).registerTypeAdapter(Duration.class, (Object)new DurationAdapter()).registerTypeAdapter(Fare.class, (Object)new FareAdapter()).registerTypeAdapter(LatLng.class, (Object)new LatLngAdapter()).registerTypeAdapter(AddressComponentType.class, new SafeEnumAdapter<AddressComponentType>(AddressComponentType.UNKNOWN)).registerTypeAdapter(AddressType.class, new SafeEnumAdapter<AddressType>(AddressType.UNKNOWN)).registerTypeAdapter(TravelMode.class, new SafeEnumAdapter<TravelMode>(TravelMode.UNKNOWN)).registerTypeAdapter(LocationType.class, new SafeEnumAdapter<LocationType>(LocationType.UNKNOWN)).registerTypeAdapter(PlaceDetails.Review.AspectRating.RatingType.class, new SafeEnumAdapter<PlaceDetails.Review.AspectRating.RatingType>(PlaceDetails.Review.AspectRating.RatingType.UNKNOWN)).registerTypeAdapter(OpeningHours.Period.OpenClose.DayOfWeek.class, (Object)new DayOfWeekAdapter()).registerTypeAdapter(PriceLevel.class, (Object)new PriceLevelAdapter()).registerTypeAdapter(Instant.class, (Object)new InstantAdapter()).registerTypeAdapter(LocalTime.class, (Object)new LocalTimeAdapter()).registerTypeAdapter(GeolocationApi.Response.class, (Object)new GeolocationResponseAdapter()).registerTypeAdapter(EncodedPolyline.class, (Object)new EncodedPolylineInstanceCreator("")).setFieldNamingPolicy(this.fieldNamingPolicy).create();
        try {
            resp = (ApiResponse)gson.fromJson(new String(bytes, StandardCharsets.UTF_8), this.responseClass);
        }
        catch (JsonSyntaxException e) {
            if (response.getResponseCode() > 399) {
                throw new IOException(String.format("Server Error: %d %s", response.getResponseCode(), new String(response.getContent(), Charset.defaultCharset())));
            }
            throw e;
        }
        if (resp.successful()) {
            return resp.getResult();
        }
        ApiException e = resp.getError();
        if (this.shouldRetry(e)) {
            return super.retry();
        }
        throw e;
    }

    private T retry() throws IOException, ApiException, InterruptedException {
        ++this.retryCounter;
        LOG.info("Retrying request. Retry #{}", (Object)this.retryCounter);
        this.metrics.startNetwork();
        this.call = this.client.fetchAsync(this.request);
        return this.await();
    }

    private boolean shouldRetry(HTTPResponse response) {
        return RETRY_ERROR_CODES.contains(response.getResponseCode()) && 0L < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }

    private boolean shouldRetry(ApiException exception) {
        return this.exceptionsAllowedToRetry.contains(exception.getClass()) && 0L < this.errorTimeOut && (this.maxRetries == null || this.retryCounter < this.maxRetries);
    }
}

