/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps.internal;

import ai.nextbillion.maps.internal.ratelimiter.RateLimiter;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RateLimitExecutorService
implements ExecutorService,
Runnable {
    private static final Logger LOG = LoggerFactory.getLogger((String)RateLimitExecutorService.class.getName());
    private static final int DEFAULT_QUERIES_PER_SECOND = 50;
    private final ExecutorService delegate = new ThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), RateLimitExecutorService.threadFactory("Rate Limited Dispatcher", true));
    private final BlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>();
    private final RateLimiter rateLimiter = RateLimiter.create(50.0, 1L, TimeUnit.SECONDS);
    final Thread delayThread;

    public RateLimitExecutorService() {
        this.setQueriesPerSecond(50);
        this.delayThread = new Thread(this);
        this.delayThread.setDaemon(true);
        this.delayThread.setName("RateLimitExecutorDelayThread");
        this.delayThread.start();
    }

    public void setQueriesPerSecond(int maxQps) {
        this.rateLimiter.setRate(maxQps);
    }

    @Override
    public void run() {
        try {
            while (!this.delegate.isShutdown()) {
                this.rateLimiter.acquire();
                Runnable r = this.queue.take();
                if (this.delegate.isShutdown()) continue;
                this.delegate.execute(r);
            }
        }
        catch (InterruptedException ie) {
            LOG.info("Interrupted", (Throwable)ie);
        }
    }

    private static ThreadFactory threadFactory(final String name, final boolean daemon) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread result = new Thread(runnable, name);
                result.setDaemon(daemon);
                return result;
            }
        };
    }

    @Override
    public void execute(Runnable runnable) {
        this.queue.add(runnable);
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
        this.execute(new Runnable(){

            @Override
            public void run() {
            }
        });
    }

    @Override
    public List<Runnable> shutdownNow() {
        List<Runnable> tasks = this.delegate.shutdownNow();
        this.execute(new Runnable(){

            @Override
            public void run() {
            }
        });
        return tasks;
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> tCallable) {
        return this.delegate.submit(tCallable);
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.delegate.submit(runnable, t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(runnable);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables) throws InterruptedException {
        return this.delegate.invokeAll(callables);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(callables, l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(callables);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> callables, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(callables, l, timeUnit);
    }
}

