/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafeEnumAdapter<E extends Enum<E>>
extends TypeAdapter<E> {
    private static final Logger LOG = LoggerFactory.getLogger((String)SafeEnumAdapter.class.getName());
    private final Class<E> clazz;
    private final E unknownValue;

    public SafeEnumAdapter(E unknownValue) {
        if (unknownValue == null) {
            throw new IllegalArgumentException();
        }
        this.unknownValue = unknownValue;
        this.clazz = ((Enum)unknownValue).getDeclaringClass();
    }

    public void write(JsonWriter out, E value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method");
    }

    public E read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String value = reader.nextString();
        try {
            return Enum.valueOf(this.clazz, value.toUpperCase(Locale.ENGLISH));
        }
        catch (IllegalArgumentException iae) {
            LOG.warn("Unknown type for enum {}: '{}'", (Object)this.clazz.getName(), (Object)value);
            return this.unknownValue;
        }
    }
}

