/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps.internal;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

public class ZonedDateTimeAdapter
extends TypeAdapter<ZonedDateTime> {
    public ZonedDateTime read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        String timeZoneId = "";
        long secondsSinceEpoch = 0L;
        reader.beginObject();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals("text")) {
                reader.nextString();
                continue;
            }
            if (name.equals("time_zone")) {
                timeZoneId = reader.nextString();
                continue;
            }
            if (!name.equals("value")) continue;
            secondsSinceEpoch = reader.nextLong();
        }
        reader.endObject();
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(secondsSinceEpoch * 1000L), ZoneId.of(timeZoneId));
    }

    public void write(JsonWriter writer, ZonedDateTime value) throws IOException {
        throw new UnsupportedOperationException("Unimplemented method");
    }
}

