/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.maps.metrics;

import ai.nextbillion.maps.metrics.OpenCensusMetrics;
import ai.nextbillion.maps.metrics.RequestMetrics;
import io.opencensus.stats.StatsRecorder;
import io.opencensus.tags.TagContext;
import io.opencensus.tags.TagValue;
import io.opencensus.tags.Tagger;

final class OpenCensusRequestMetrics
implements RequestMetrics {
    private final String requestName;
    private final Tagger tagger;
    private final StatsRecorder statsRecorder;
    private final long requestStart;
    private long networkStart;
    private long networkTime;
    private boolean finished;

    OpenCensusRequestMetrics(String requestName, Tagger tagger, StatsRecorder statsRecorder) {
        this.requestName = requestName;
        this.tagger = tagger;
        this.statsRecorder = statsRecorder;
        this.requestStart = this.milliTime();
        this.networkStart = this.milliTime();
        this.networkTime = 0L;
        this.finished = false;
    }

    @Override
    public void startNetwork() {
        this.networkStart = this.milliTime();
    }

    @Override
    public void endNetwork() {
        this.networkTime += this.milliTime() - this.networkStart;
    }

    @Override
    public void endRequest(Exception exception, int httpStatusCode, long retryCount) {
        if (this.finished) {
            return;
        }
        this.finished = true;
        long requestTime = this.milliTime() - this.requestStart;
        TagContext tagContext = this.tagger.currentBuilder().putLocal(OpenCensusMetrics.Tags.REQUEST_NAME, TagValue.create((String)this.requestName)).putLocal(OpenCensusMetrics.Tags.HTTP_CODE, TagValue.create((String)Integer.toString(httpStatusCode))).putLocal(OpenCensusMetrics.Tags.API_STATUS, TagValue.create((String)this.exceptionName(exception))).build();
        this.statsRecorder.newMeasureMap().put(OpenCensusMetrics.Measures.LATENCY, requestTime).put(OpenCensusMetrics.Measures.NETWORK_LATENCY, this.networkTime).put(OpenCensusMetrics.Measures.RETRY_COUNT, retryCount).record(tagContext);
    }

    private String exceptionName(Exception exception) {
        if (exception == null) {
            return "";
        }
        return exception.getClass().getName();
    }

    private long milliTime() {
        return System.currentTimeMillis();
    }
}

