/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.api;

import ai.nextbillion.api.directions.NBDirections;
import ai.nextbillion.api.directions.NBDirectionsResponse;
import ai.nextbillion.api.distancematrix.NBDistanceMatrix;
import ai.nextbillion.api.distancematrix.NBDistanceMatrixResponse;
import ai.nextbillion.api.models.NBLocation;
import ai.nextbillion.api.snaptoroad.NBSnapToRoad;
import ai.nextbillion.api.snaptoroad.NBSnapToRoadResponse;
import java.io.IOException;
import java.util.List;
import retrofit2.Callback;
import retrofit2.Response;

public class NBMapAPI {
    private String key;
    private String mode;
    private String baseUrl;
    private boolean debug = false;

    public static NBMapAPI getInstance() {
        return BillPughSingleton.INSTANCE;
    }

    public static NBMapAPI getInstance(String key, String baseUrl) {
        NBMapAPI instance = BillPughSingleton.INSTANCE;
        instance.setKey(key);
        instance.setBaseUrl(baseUrl);
        return instance;
    }

    public static NBMapAPI getDebugInstance() {
        NBMapAPI instance = BillPughSingleton.INSTANCE;
        instance.setKey("plaintesting");
        instance.setMode("4w");
        instance.setBaseUrl("https://api.nextbillion.io");
        return instance;
    }

    private NBMapAPI() {
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public Response<NBDirectionsResponse> getDirections(NBLocation origin, NBLocation destination) throws IOException {
        int departureTime = (int)System.currentTimeMillis() / 1000;
        NBDirections nbDirections = this.getDirectionsBuilder().origin(origin).destination(destination).departureTime(departureTime).build();
        nbDirections.enableDebug(this.debug);
        return nbDirections.executeCall();
    }

    public void enqueueGetDirections(NBLocation origin, NBLocation destination, Callback<NBDirectionsResponse> callback) {
        int departureTime = (int)System.currentTimeMillis() / 1000;
        NBDirections nbDirections = this.getDirectionsBuilder().origin(origin).destination(destination).departureTime(departureTime).build();
        nbDirections.enableDebug(this.debug);
        nbDirections.enqueueCall(callback);
    }

    public NBDirections.Builder getDirectionsBuilder() {
        return NBDirections.builder().alternativeCount(1).alternatives(true).baseUrl(this.baseUrl).key(this.key).mode(this.mode).debug(this.debug).steps(true);
    }

    public Response<NBDistanceMatrixResponse> getDistanceMatrix(List<NBLocation> origins, List<NBLocation> destinations) throws IOException {
        NBDistanceMatrix distanceMatrix = this.getDistanceMatrixBuilder().origins(origins).destinations(destinations).departureTime((int)System.currentTimeMillis() / 1000).build();
        distanceMatrix.enableDebug(this.debug);
        return distanceMatrix.executeCall();
    }

    public void enqueueGetDistanceMatrix(List<NBLocation> origins, List<NBLocation> destinations, Callback<NBDistanceMatrixResponse> callback) {
        NBDistanceMatrix distanceMatrix = this.getDistanceMatrixBuilder().origins(origins).destinations(destinations).departureTime((int)System.currentTimeMillis() / 1000).build();
        distanceMatrix.enableDebug(this.debug);
        distanceMatrix.enqueueCall(callback);
    }

    public NBDistanceMatrix.Builder getDistanceMatrixBuilder() {
        return NBDistanceMatrix.builder().baseUrl(this.baseUrl).mode(this.mode).debug(this.debug).key(this.key);
    }

    public Response<NBSnapToRoadResponse> getSnapToRoad(List<NBLocation> pointsOnPath) throws IOException {
        NBSnapToRoad snapToRoad = this.getSnapToRoadBuilder().path(pointsOnPath).build();
        snapToRoad.enableDebug(this.debug);
        return snapToRoad.executeCall();
    }

    public void enqueueGetSnapToRoads(List<NBLocation> pointsOnPath, Callback<NBSnapToRoadResponse> callback) {
        NBSnapToRoad snapToRoad = this.getSnapToRoadBuilder().path(pointsOnPath).build();
        snapToRoad.enableDebug(this.debug);
        snapToRoad.enqueueCall(callback);
    }

    public NBSnapToRoad.Builder getSnapToRoadBuilder() {
        return NBSnapToRoad.builder().baseUrl(this.baseUrl).key(this.key).interpolate(true).tolerateOutlier(false);
    }

    private static class BillPughSingleton {
        private static final NBMapAPI INSTANCE = new NBMapAPI();

        private BillPughSingleton() {
        }
    }
}

