/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.api.distancematrix;

import ai.nextbillion.api.distancematrix.AutoValue_NBDistanceMatrix;
import ai.nextbillion.api.distancematrix.NBDistanceMatrixAdapterFactory;
import ai.nextbillion.api.distancematrix.NBDistanceMatrixResponse;
import ai.nextbillion.api.distancematrix.NBDistanceMatrixService;
import ai.nextbillion.api.models.NBLocation;
import ai.nextbillion.api.utils.FormatUtils;
import androidx.annotation.NonNull;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.nbmap.core.NbmapService;
import java.util.List;
import retrofit2.Call;

@AutoValue
public abstract class NBDistanceMatrix
extends NbmapService<NBDistanceMatrixResponse, NBDistanceMatrixService> {
    public NBDistanceMatrix() {
        super(NBDistanceMatrixService.class);
    }

    protected abstract String baseUrl();

    protected Call<NBDistanceMatrixResponse> initializeCall() {
        return ((NBDistanceMatrixService)this.getService()).getDistanceMatrix(this.debug(), this.departureTime(), this.locationsToString(this.destinations()), this.key(), this.mode(), this.locationsToString(this.origins()));
    }

    private String locationsToString(@NonNull List<NBLocation> locations) {
        return FormatUtils.join("|", locations);
    }

    abstract boolean debug();

    abstract int departureTime();

    abstract List<NBLocation> destinations();

    abstract String key();

    abstract String mode();

    abstract List<NBLocation> origins();

    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder().registerTypeAdapterFactory(NBDistanceMatrixAdapterFactory.create());
    }

    public static Builder builder() {
        return new AutoValue_NBDistanceMatrix.Builder().baseUrl("https://api.nextbillion.io");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder baseUrl(String var1);

        public abstract Builder debug(boolean var1);

        public abstract Builder departureTime(int var1);

        public abstract Builder destinations(List<NBLocation> var1);

        public abstract Builder key(String var1);

        public abstract Builder mode(String var1);

        public abstract Builder origins(List<NBLocation> var1);

        public abstract NBDistanceMatrix build();
    }
}

