/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.api.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.nbmap.geojson.Point;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class FormatUtils {
    @Nullable
    public static String join(@NonNull CharSequence delimiter, @Nullable List<?> tokens) {
        return FormatUtils.join(delimiter, tokens, false);
    }

    @Nullable
    public static String join(@NonNull CharSequence delimiter, @Nullable List<?> tokens, boolean removeTrailingNulls) {
        if (tokens == null || tokens.size() < 1) {
            return null;
        }
        int lastNonNullToken = tokens.size() - 1;
        if (removeTrailingNulls) {
            Object token;
            for (int i = tokens.size() - 1; i >= 0 && (token = tokens.get(i)) == null; --i) {
                --lastNonNullToken;
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean firstTime = true;
        for (int i = 0; i <= lastNonNullToken; ++i) {
            if (firstTime) {
                firstTime = false;
            } else {
                sb.append(delimiter);
            }
            Object token = tokens.get(i);
            if (token == null) continue;
            sb.append(token);
        }
        return sb.toString();
    }

    @NonNull
    public static String formatCoordinate(double coordinate) {
        DecimalFormat decimalFormat = new DecimalFormat("0.######", new DecimalFormatSymbols(Locale.US));
        return String.format(Locale.US, "%s", decimalFormat.format(coordinate));
    }

    @Nullable
    public static String formatRadiuses(@Nullable List<Double> radiuses) {
        if (radiuses == null || radiuses.size() == 0) {
            return null;
        }
        ArrayList<String> radiusesToJoin = new ArrayList<String>();
        for (Double radius : radiuses) {
            if (radius == null) {
                radiusesToJoin.add(null);
                continue;
            }
            if (radius == Double.POSITIVE_INFINITY) {
                radiusesToJoin.add("unlimited");
                continue;
            }
            radiusesToJoin.add(String.format(Locale.US, "%s", FormatUtils.formatCoordinate(radius)));
        }
        return FormatUtils.join(";", radiusesToJoin);
    }

    @Nullable
    public static String formatBearings(@Nullable List<List<Double>> bearings) {
        if (bearings == null || bearings.isEmpty()) {
            return null;
        }
        ArrayList<String> bearingsToJoin = new ArrayList<String>();
        for (List<Double> bearing : bearings) {
            if (bearing == null) {
                bearingsToJoin.add(null);
                continue;
            }
            if (bearing.size() != 2) {
                throw new RuntimeException("Bearing size should be 2.");
            }
            Double angle = bearing.get(0);
            Double tolerance = bearing.get(1);
            if (angle == null || tolerance == null) {
                bearingsToJoin.add(null);
                continue;
            }
            if (angle < 0.0 || angle > 360.0 || tolerance < 0.0 || tolerance > 360.0) {
                throw new RuntimeException("Angle and tolerance have to be from 0 to 360.");
            }
            bearingsToJoin.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(angle), FormatUtils.formatCoordinate(tolerance)));
        }
        return FormatUtils.join(";", bearingsToJoin);
    }

    @Nullable
    public static String formatDistributions(@Nullable List<Integer[]> distributions) {
        if (distributions == null || distributions.isEmpty()) {
            return null;
        }
        ArrayList<String> distributionsToJoin = new ArrayList<String>();
        for (Integer[] array : distributions) {
            if (array.length == 0) {
                distributionsToJoin.add(null);
                continue;
            }
            distributionsToJoin.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(array[0].intValue()), FormatUtils.formatCoordinate(array[1].intValue())));
        }
        return FormatUtils.join(";", distributionsToJoin);
    }

    @Nullable
    public static String formatApproaches(@Nullable List<String> approaches) {
        if (approaches == null || approaches.isEmpty()) {
            return null;
        }
        for (String approach : approaches) {
            if (approach == null || approach.equals("unrestricted") || approach.equals("curb") || approach.isEmpty()) continue;
            return null;
        }
        return FormatUtils.join(";", approaches);
    }

    @Nullable
    public static String formatWaypointNames(@Nullable List<String> waypointNames) {
        if (waypointNames == null || waypointNames.isEmpty()) {
            return null;
        }
        return FormatUtils.join(";", waypointNames);
    }

    @Nullable
    public static String formatCoordinates(@NonNull List<Point> coordinates) {
        ArrayList<String> coordinatesToJoin = new ArrayList<String>();
        for (Point point : coordinates) {
            coordinatesToJoin.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(point.longitude()), FormatUtils.formatCoordinate(point.latitude())));
        }
        return FormatUtils.join(";", coordinatesToJoin);
    }

    @Nullable
    public static String formatPointsList(@Nullable List<Point> points) {
        if (points == null || points.isEmpty()) {
            return null;
        }
        ArrayList<String> coordinatesToJoin = new ArrayList<String>();
        for (Point point : points) {
            if (point == null) {
                coordinatesToJoin.add(null);
                continue;
            }
            coordinatesToJoin.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate(point.longitude()), FormatUtils.formatCoordinate(point.latitude())));
        }
        return FormatUtils.join(";", coordinatesToJoin);
    }
}

