/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.api.utils;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.nbmap.geojson.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ParseUtils {
    private static final String SEMICOLON = ";";
    private static final String COMMA = ",";
    private static final String UNLIMITED = "unlimited";
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    @Nullable
    public static List<Integer> parseToIntegers(@Nullable String original) {
        String[] strings;
        if (original == null) {
            return null;
        }
        ArrayList<Integer> integers = new ArrayList<Integer>();
        for (String index : strings = original.split(SEMICOLON)) {
            if (index == null) continue;
            if (index.isEmpty()) {
                integers.add(null);
                continue;
            }
            integers.add(Integer.valueOf(index));
        }
        return integers;
    }

    @Nullable
    public static List<String> parseToStrings(@Nullable String original) {
        return ParseUtils.parseToStrings(original, SEMICOLON);
    }

    @Nullable
    public static List<String> parseToStrings(@Nullable String original, @NonNull String separator) {
        String[] strings;
        if (original == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String str : strings = original.split(separator, -1)) {
            if (str == null) continue;
            if (str.isEmpty()) {
                result.add(null);
                continue;
            }
            result.add(str);
        }
        return result;
    }

    @Nullable
    public static List<Point> parseToPoints(@Nullable String original) {
        String[] targets;
        if (original == null) {
            return null;
        }
        ArrayList<Point> points = new ArrayList<Point>();
        for (String target : targets = original.split(SEMICOLON, -1)) {
            if (target == null) continue;
            if (target.isEmpty()) {
                points.add(null);
                continue;
            }
            String[] point = target.split(COMMA);
            points.add(Point.fromLngLat((double)Double.valueOf(point[0]), (double)Double.valueOf(point[1])));
        }
        return points;
    }

    @Nullable
    public static List<Double> parseToDoubles(@Nullable String original) {
        String[] strings;
        if (original == null) {
            return null;
        }
        ArrayList<Double> doubles = new ArrayList<Double>();
        for (String str : strings = original.split(SEMICOLON, -1)) {
            if (str == null) continue;
            if (str.isEmpty()) {
                doubles.add(null);
                continue;
            }
            if (str.equals(UNLIMITED)) {
                doubles.add(Double.POSITIVE_INFINITY);
                continue;
            }
            doubles.add(Double.valueOf(str));
        }
        return doubles;
    }

    @Nullable
    public static List<List<Double>> parseToListOfListOfDoubles(@Nullable String original) {
        String[] pairs;
        if (original == null) {
            return null;
        }
        ArrayList<List<Double>> result = new ArrayList<List<Double>>();
        for (String pair : pairs = original.split(SEMICOLON, -1)) {
            if (pair.isEmpty()) {
                result.add(null);
                continue;
            }
            String[] values = pair.split(COMMA);
            if (values.length != 2) continue;
            result.add(Arrays.asList(Double.valueOf(values[0]), Double.valueOf(values[1])));
        }
        return result;
    }

    @Nullable
    public static List<Boolean> parseToBooleans(@Nullable String original) {
        String[] strings;
        if (original == null) {
            return null;
        }
        ArrayList<Boolean> booleans = new ArrayList<Boolean>();
        if (original.isEmpty()) {
            return booleans;
        }
        for (String str : strings = original.split(SEMICOLON, -1)) {
            if (str == null) continue;
            if (str.isEmpty()) {
                booleans.add(null);
                continue;
            }
            if (str.equalsIgnoreCase(TRUE)) {
                booleans.add(true);
                continue;
            }
            if (str.equalsIgnoreCase(FALSE)) {
                booleans.add(false);
                continue;
            }
            booleans.add(null);
        }
        return booleans;
    }
}

