package com.nbmap.api.directionsrefresh.v1.models;

import com.google.gson.GsonBuilder;
import com.nbmap.api.directions.v5.DirectionsAdapterFactory;
import com.nbmap.api.directionsrefresh.v1.DirectionsRefreshAdapterFactory;
import com.nbmap.geojson.Point;
import com.nbmap.geojson.PointAsCoordinatesTypeAdapter;
import java.io.Serializable;

/**
 * Provides a base class for Directions model classes.
 */
public class DirectionsRefreshJsonObject implements Serializable {

  /**
   * This takes the currently defined values found inside this instance and converts it to a json
   * string.
   *
   * @return a JSON string which represents this DirectionsJsonObject
   */
  public String toJson() {
    GsonBuilder gson = new GsonBuilder();
    gson.registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    gson.registerTypeAdapter(Point.class, new PointAsCoordinatesTypeAdapter());
    gson.registerTypeAdapterFactory(DirectionsRefreshAdapterFactory.create());
    return gson.create().toJson(this);
  }
}
