/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.directions.v5;

import com.nbmap.api.directions.v5.NbmapDirections;
import com.nbmap.api.directions.v5.models.DirectionsResponse;
import com.nbmap.api.directions.v5.models.DirectionsRoute;
import com.nbmap.api.directions.v5.models.RouteOptions;
import com.nbmap.api.directions.v5.utils.ParseUtils;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

class DirectionsResponseFactory {
    private final NbmapDirections nbmapDirections;

    DirectionsResponseFactory(NbmapDirections nbmapDirections) {
        this.nbmapDirections = nbmapDirections;
    }

    retrofit2.Response<DirectionsResponse> generate(retrofit2.Response<DirectionsResponse> response) {
        if (this.isNotSuccessful(response)) {
            return response;
        }
        return retrofit2.Response.success((Object)((DirectionsResponse)response.body()).toBuilder().routes(this.generateRouteOptions(response)).build(), (Response)new Response.Builder().code(200).message("OK").protocol(response.raw().protocol()).headers(response.headers()).request(response.raw().request()).build());
    }

    private boolean isNotSuccessful(retrofit2.Response<DirectionsResponse> response) {
        return !response.isSuccessful() || response.body() == null || ((DirectionsResponse)response.body()).routes().isEmpty();
    }

    private List<DirectionsRoute> generateRouteOptions(retrofit2.Response<DirectionsResponse> response) {
        List routes = ((DirectionsResponse)response.body()).routes();
        ArrayList<DirectionsRoute> modifiedRoutes = new ArrayList<DirectionsRoute>();
        for (DirectionsRoute route : routes) {
            modifiedRoutes.add(route.toBuilder().routeOptions(RouteOptions.builder().profile(this.nbmapDirections.profile()).coordinates(this.nbmapDirections.coordinates()).waypointIndicesList(ParseUtils.parseToIntegers((String)this.nbmapDirections.waypointIndices())).waypointNamesList(ParseUtils.parseToStrings((String)this.nbmapDirections.waypointNames())).waypointTargetsList(ParseUtils.parseToPoints((String)this.nbmapDirections.waypointTargets())).continueStraight(this.nbmapDirections.continueStraight()).annotationsList(ParseUtils.parseToStrings((String)this.nbmapDirections.annotation())).approachesList(ParseUtils.parseToStrings((String)this.nbmapDirections.approaches())).bearingsList(ParseUtils.parseToListOfListOfDoubles((String)this.nbmapDirections.bearing())).alternatives(this.nbmapDirections.alternatives()).language(this.nbmapDirections.language()).radiusesList(ParseUtils.parseToDoubles((String)this.nbmapDirections.radius())).user(this.nbmapDirections.user()).voiceInstructions(this.nbmapDirections.voiceInstructions()).bannerInstructions(this.nbmapDirections.bannerInstructions()).roundaboutExits(this.nbmapDirections.roundaboutExits()).geometries(this.nbmapDirections.geometries()).overview(this.nbmapDirections.overview()).steps(this.nbmapDirections.steps()).exclude(this.nbmapDirections.exclude()).voiceUnits(this.nbmapDirections.voiceUnits()).accessToken(this.nbmapDirections.accessToken()).requestUuid(((DirectionsResponse)response.body()).uuid()).baseUrl(this.nbmapDirections.baseUrl()).walkingOptions(this.nbmapDirections.walkingOptions()).snappingClosures(this.nbmapDirections.snappingClosures()).build()).build());
        }
        return modifiedRoutes;
    }
}

