/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.geocoding.v5;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.nbmap.api.geocoding.v5.AutoValue_NbmapGeocoding;
import com.nbmap.api.geocoding.v5.GeocodingCriteria;
import com.nbmap.api.geocoding.v5.GeocodingService;
import com.nbmap.api.geocoding.v5.SingleElementSafeListTypeAdapter;
import com.nbmap.api.geocoding.v5.models.GeocodingAdapterFactory;
import com.nbmap.api.geocoding.v5.models.GeocodingResponse;
import com.nbmap.core.NbmapService;
import com.nbmap.core.exceptions.ServicesException;
import com.nbmap.core.utils.ApiCallHelper;
import com.nbmap.core.utils.NbmapUtils;
import com.nbmap.core.utils.TextUtils;
import com.nbmap.geojson.BoundingBox;
import com.nbmap.geojson.GeometryAdapterFactory;
import com.nbmap.geojson.Point;
import com.nbmap.geojson.gson.BoundingBoxTypeAdapter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@AutoValue
public abstract class NbmapGeocoding
extends NbmapService<GeocodingResponse, GeocodingService> {
    private Call<List<GeocodingResponse>> batchCall;

    protected NbmapGeocoding() {
        super(GeocodingService.class);
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(GeocodingAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create()).registerTypeAdapterFactory(SingleElementSafeListTypeAdapter.FACTORY).registerTypeAdapter(BoundingBox.class, (Object)new BoundingBoxTypeAdapter());
    }

    protected Call<GeocodingResponse> initializeCall() {
        if (this.mode().contains("nbmap.places-permanent")) {
            throw new IllegalArgumentException("Use getBatchCall() for batch calls.");
        }
        return ((GeocodingService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.mode(), this.query(), this.accessToken(), this.country(), this.proximity(), this.geocodingTypes(), this.autocomplete(), this.bbox(), this.limit(), this.languages(), this.reverseMode(), this.fuzzyMatch());
    }

    private Call<List<GeocodingResponse>> getBatchCall() {
        if (this.batchCall != null) {
            return this.batchCall;
        }
        if (this.mode().equals("nbmap.places")) {
            throw new ServicesException("Use getCall() for non-batch calls or set the mode to `permanent` for batch requests.");
        }
        this.batchCall = ((GeocodingService)this.getService()).getBatchCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.mode(), this.query(), this.accessToken(), this.country(), this.proximity(), this.geocodingTypes(), this.autocomplete(), this.bbox(), this.limit(), this.languages(), this.reverseMode(), this.fuzzyMatch());
        return this.batchCall;
    }

    public Response<List<GeocodingResponse>> executeBatchCall() throws IOException {
        return this.getBatchCall().execute();
    }

    public void enqueueBatchCall(Callback<List<GeocodingResponse>> callback) {
        this.getBatchCall().enqueue(callback);
    }

    public void cancelBatchCall() {
        this.getBatchCall().cancel();
    }

    public Call<List<GeocodingResponse>> cloneBatchCall() {
        return this.getBatchCall().clone();
    }

    @NonNull
    abstract String query();

    @NonNull
    abstract String mode();

    @NonNull
    abstract String accessToken();

    @NonNull
    protected abstract String baseUrl();

    @Nullable
    abstract String country();

    @Nullable
    abstract String proximity();

    @Nullable
    abstract String geocodingTypes();

    @Nullable
    abstract Boolean autocomplete();

    @Nullable
    abstract String bbox();

    @Nullable
    abstract String limit();

    @Nullable
    abstract String languages();

    @Nullable
    abstract String reverseMode();

    @Nullable
    abstract Boolean fuzzyMatch();

    @Nullable
    abstract String clientAppName();

    public static Builder builder() {
        return new AutoValue_NbmapGeocoding.Builder().baseUrl("https://api.nextbillion.io").mode("nbmap.places");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private List<String> countries = new ArrayList<String>();
        private List<String> intersectionStreets = new ArrayList<String>();

        public Builder query(@NonNull Point point) {
            this.query(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)point.longitude()), TextUtils.formatCoordinate((double)point.latitude())));
            return this;
        }

        public abstract Builder query(@NonNull String var1);

        public abstract Builder mode(@NonNull @GeocodingCriteria.GeocodingModeCriteria String var1);

        public Builder proximity(@NonNull Point proximity) {
            this.proximity(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)proximity.longitude()), proximity.latitude()));
            return this;
        }

        abstract Builder proximity(String var1);

        public Builder geocodingTypes(String ... geocodingTypes) {
            this.geocodingTypes(TextUtils.join((CharSequence)",", (Object[])geocodingTypes));
            return this;
        }

        abstract Builder geocodingTypes(String var1);

        public Builder country(Locale country) {
            this.countries.add(country.getCountry());
            return this;
        }

        public Builder country(String ... country) {
            this.countries.addAll(Arrays.asList(country));
            return this;
        }

        public abstract Builder country(String var1);

        public abstract Builder autocomplete(Boolean var1);

        public Builder bbox(BoundingBox bbox) {
            this.bbox(bbox.southwest().longitude(), bbox.southwest().latitude(), bbox.northeast().longitude(), bbox.northeast().latitude());
            return this;
        }

        public Builder bbox(Point southwest, Point northeast) {
            this.bbox(southwest.longitude(), southwest.latitude(), northeast.longitude(), northeast.latitude());
            return this;
        }

        public Builder bbox(@FloatRange(from=-180.0, to=180.0) double minX, @FloatRange(from=-90.0, to=90.0) double minY, @FloatRange(from=-180.0, to=180.0) double maxX, @FloatRange(from=-90.0, to=90.0) double maxY) {
            this.bbox(String.format(Locale.US, "%s,%s,%s,%s", TextUtils.formatCoordinate((double)minX), TextUtils.formatCoordinate((double)minY), TextUtils.formatCoordinate((double)maxX), TextUtils.formatCoordinate((double)maxY)));
            return this;
        }

        public abstract Builder bbox(@NonNull String var1);

        public Builder limit(@IntRange(from=1L, to=10L) int limit) {
            this.limit(String.valueOf(limit));
            return this;
        }

        abstract Builder limit(String var1);

        public Builder languages(Locale ... languages) {
            Object[] languageStrings = new String[languages.length];
            for (int i = 0; i < languages.length; ++i) {
                languageStrings[i] = languages[i].getLanguage();
            }
            this.languages(TextUtils.join((CharSequence)",", (Object[])languageStrings));
            return this;
        }

        public abstract Builder languages(String var1);

        public abstract Builder reverseMode(@Nullable @GeocodingCriteria.GeocodingReverseModeCriteria String var1);

        public abstract Builder fuzzyMatch(Boolean var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder clientAppName(@NonNull String var1);

        public abstract Builder baseUrl(@NonNull String var1);

        abstract NbmapGeocoding autoBuild();

        public Builder intersectionStreets(@NonNull String streetOneName, @NonNull String streetTwoName) {
            this.intersectionStreets.add(streetOneName);
            this.intersectionStreets.add(streetTwoName);
            return this;
        }

        public NbmapGeocoding build() {
            NbmapGeocoding geocoding;
            if (!this.countries.isEmpty()) {
                this.country(TextUtils.join((CharSequence)",", (Object[])this.countries.toArray()));
            }
            if (this.intersectionStreets.size() == 2) {
                this.query(TextUtils.join((CharSequence)" and ", (Object[])this.intersectionStreets.toArray()));
                this.geocodingTypes("address");
            }
            if (!NbmapUtils.isAccessTokenValid((String)(geocoding = this.autoBuild()).accessToken())) {
                throw new ServicesException("Using Nbmap Services requires setting a valid access token.");
            }
            if (geocoding.query().isEmpty()) {
                throw new ServicesException("A query with at least one character or digit is required.");
            }
            if (geocoding.reverseMode() != null && geocoding.limit() != null && !geocoding.limit().equals("1")) {
                throw new ServicesException("Limit must be combined with a single type parameter");
            }
            if (this.intersectionStreets.size() == 2) {
                if (!geocoding.mode().equals("nbmap.places") && !geocoding.mode().equals("nbmap.places-permanent")) {
                    throw new ServicesException("Geocoding mode must be GeocodingCriteria.MODE_PLACES or GeocodingCriteria.MODE_PLACES_PERMANENT for intersection search.");
                }
                if (TextUtils.isEmpty((CharSequence)geocoding.geocodingTypes()) || !geocoding.geocodingTypes().equals("address")) {
                    throw new ServicesException("Geocoding type must be set to Geocoding Criteria.TYPE_ADDRESS for intersection search.");
                }
                if (TextUtils.isEmpty((CharSequence)geocoding.proximity())) {
                    throw new ServicesException("Geocoding proximity must be set for intersection search.");
                }
            }
            return geocoding;
        }
    }
}

