/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.geocoding.v5;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.google.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

class SingleElementSafeListTypeAdapter<E>
extends TypeAdapter<List<E>> {
    static final TypeAdapterFactory FACTORY = new TypeAdapterFactory(){

        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> typeToken) {
            Class rawType = typeToken.getRawType();
            if (!List.class.isAssignableFrom(rawType)) {
                return null;
            }
            Type elementType = .Gson.Types.getCollectionElementType((Type)typeToken.getType(), (Class)rawType);
            TypeAdapter elementTypeAdapter = gson.getAdapter(TypeToken.get((Type)elementType));
            SingleElementSafeListTypeAdapter adapter = new SingleElementSafeListTypeAdapter(elementTypeAdapter);
            return adapter;
        }
    };
    private final TypeAdapter<E> elementTypeAdapter;

    private SingleElementSafeListTypeAdapter(TypeAdapter<E> elementTypeAdapter) {
        this.elementTypeAdapter = elementTypeAdapter;
    }

    public List<E> read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        ArrayList<Object> elements = new ArrayList<Object>();
        switch (token) {
            case BEGIN_ARRAY: {
                in.beginArray();
                while (in.hasNext()) {
                    elements.add(this.elementTypeAdapter.read(in));
                }
                in.endArray();
                return elements;
            }
            case BEGIN_OBJECT: 
            case STRING: 
            case NUMBER: 
            case BOOLEAN: {
                elements.add(this.elementTypeAdapter.read(in));
                return elements;
            }
            case NULL: {
                in.nextNull();
                return null;
            }
            case NAME: 
            case END_ARRAY: 
            case END_OBJECT: 
            case END_DOCUMENT: {
                throw new MalformedJsonException("Unexpected token: " + token);
            }
        }
        throw new IllegalStateException("Unprocessed token: " + token);
    }

    public void write(JsonWriter out, List<E> value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.beginArray();
        for (E element : value) {
            this.elementTypeAdapter.write(out, element);
        }
        out.endArray();
    }
}

