/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.geocoding.v5.models;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;
import com.nbmap.api.geocoding.v5.models.$AutoValue_CarmenFeature;
import com.nbmap.api.geocoding.v5.models.AutoValue_CarmenFeature;
import com.nbmap.api.geocoding.v5.models.CarmenContext;
import com.nbmap.api.geocoding.v5.models.GeocodingAdapterFactory;
import com.nbmap.geojson.BoundingBox;
import com.nbmap.geojson.GeoJson;
import com.nbmap.geojson.Geometry;
import com.nbmap.geojson.GeometryAdapterFactory;
import com.nbmap.geojson.Point;
import com.nbmap.geojson.gson.BoundingBoxTypeAdapter;
import java.util.List;

@AutoValue
public abstract class CarmenFeature
implements GeoJson {
    private static final String TYPE = "Feature";

    @NonNull
    public static CarmenFeature fromJson(@NonNull String json) {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(GeometryAdapterFactory.create()).registerTypeAdapter(BoundingBox.class, (Object)new BoundingBoxTypeAdapter()).registerTypeAdapterFactory(GeocodingAdapterFactory.create()).create();
        CarmenFeature feature = (CarmenFeature)gson.fromJson(json, CarmenFeature.class);
        return feature.properties() == null ? feature.toBuilder().properties(new JsonObject()).build() : feature;
    }

    @NonNull
    public static Builder builder() {
        return new $AutoValue_CarmenFeature.Builder().type(TYPE).properties(new JsonObject());
    }

    @SerializedName(value="type")
    @NonNull
    public abstract String type();

    @Nullable
    public abstract BoundingBox bbox();

    @Nullable
    public abstract String id();

    @Nullable
    public abstract Geometry geometry();

    @Nullable
    public abstract JsonObject properties();

    @Nullable
    public abstract String text();

    @SerializedName(value="place_name")
    @Nullable
    public abstract String placeName();

    @SerializedName(value="place_type")
    @Nullable
    public abstract List<String> placeType();

    @Nullable
    public abstract String address();

    @Nullable
    public Point center() {
        double[] center = this.rawCenter();
        if (center != null && center.length == 2) {
            return Point.fromLngLat((double)center[0], (double)center[1]);
        }
        return null;
    }

    @SerializedName(value="center")
    @Nullable
    abstract double[] rawCenter();

    @Nullable
    public abstract List<CarmenContext> context();

    @Nullable
    public abstract Double relevance();

    @SerializedName(value="matching_text")
    @Nullable
    public abstract String matchingText();

    @SerializedName(value="matching_place_name")
    @Nullable
    public abstract String matchingPlaceName();

    @Nullable
    public abstract String language();

    public static TypeAdapter<CarmenFeature> typeAdapter(Gson gson) {
        return new AutoValue_CarmenFeature.GsonTypeAdapter(gson);
    }

    public String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapterFactory(GeometryAdapterFactory.create()).registerTypeAdapter(BoundingBox.class, (Object)new BoundingBoxTypeAdapter()).registerTypeAdapterFactory(GeocodingAdapterFactory.create()).create();
        CarmenFeature feature = this;
        if (this.properties() != null && this.properties().size() == 0) {
            feature = this.toBuilder().properties(null).build();
        }
        return gson.toJson((Object)feature, CarmenFeature.class);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder type(@NonNull String var1);

        public abstract Builder bbox(@Nullable BoundingBox var1);

        public abstract Builder id(@Nullable String var1);

        public abstract Builder geometry(@Nullable Geometry var1);

        public abstract Builder properties(@Nullable JsonObject var1);

        public abstract Builder text(@Nullable String var1);

        public abstract Builder placeName(@Nullable String var1);

        public abstract Builder placeType(@Nullable List<String> var1);

        public abstract Builder address(@Nullable String var1);

        public abstract Builder rawCenter(@Nullable double[] var1);

        public abstract Builder context(@Nullable List<CarmenContext> var1);

        public abstract Builder relevance(@Nullable Double var1);

        public abstract Builder matchingText(@Nullable String var1);

        public abstract Builder matchingPlaceName(@Nullable String var1);

        public abstract Builder language(@Nullable String var1);

        public abstract CarmenFeature build();
    }
}

