/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.isochrone;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.nbmap.api.isochrone.AutoValue_NbmapIsochrone;
import com.nbmap.api.isochrone.IsochroneCriteria;
import com.nbmap.api.isochrone.IsochroneService;
import com.nbmap.core.NbmapService;
import com.nbmap.core.exceptions.ServicesException;
import com.nbmap.core.utils.NbmapUtils;
import com.nbmap.core.utils.TextUtils;
import com.nbmap.geojson.FeatureCollection;
import com.nbmap.geojson.GeometryAdapterFactory;
import com.nbmap.geojson.Point;
import com.nbmap.geojson.gson.GeoJsonAdapterFactory;
import java.util.Locale;
import retrofit2.Call;

@AutoValue
public abstract class NbmapIsochrone
extends NbmapService<FeatureCollection, IsochroneService> {
    protected NbmapIsochrone() {
        super(IsochroneService.class);
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(GeoJsonAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create());
    }

    protected Call<FeatureCollection> initializeCall() {
        return ((IsochroneService)this.getService()).getCall(this.user(), this.profile(), this.coordinates(), this.contoursMinutes(), this.accessToken(), this.contoursColors(), this.polygons(), this.denoise(), this.generalize());
    }

    public static Builder builder() {
        return new AutoValue_NbmapIsochrone.Builder().baseUrl("https://api.nextbillion.io").user("nbmap");
    }

    @NonNull
    protected abstract String baseUrl();

    @NonNull
    abstract String accessToken();

    @NonNull
    abstract String user();

    @NonNull
    abstract String profile();

    @NonNull
    abstract String coordinates();

    @NonNull
    abstract String contoursMinutes();

    @Nullable
    abstract String contoursColors();

    @Nullable
    abstract Boolean polygons();

    @Nullable
    abstract Float denoise();

    @Nullable
    abstract Float generalize();

    @AutoValue.Builder
    public static abstract class Builder {
        private Integer[] contoursMinutes;
        private String[] contoursColors;

        public abstract Builder baseUrl(@NonNull String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder user(@NonNull String var1);

        public abstract Builder profile(@Nullable @IsochroneCriteria.IsochroneProfile String var1);

        public Builder coordinates(@NonNull Point queryPoint) {
            this.coordinates(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)queryPoint.longitude()), TextUtils.formatCoordinate((double)queryPoint.latitude())));
            return this;
        }

        public abstract Builder coordinates(@NonNull String var1);

        public Builder addContoursMinutes(Integer ... listOfMinuteValues) {
            this.contoursMinutes = listOfMinuteValues;
            return this;
        }

        abstract Builder contoursMinutes(@NonNull String var1);

        public Builder addContoursColors(String ... contoursColors) {
            this.contoursColors = contoursColors;
            return this;
        }

        abstract Builder contoursColors(@Nullable String var1);

        public abstract Builder polygons(@Nullable Boolean var1);

        public abstract Builder denoise(@Nullable @FloatRange(from=0.0, to=1.0) Float var1);

        public abstract Builder generalize(@Nullable @FloatRange(from=0.0) Float var1);

        abstract NbmapIsochrone autoBuild();

        public NbmapIsochrone build() {
            if (this.contoursMinutes != null) {
                if (this.contoursMinutes.length < 1) {
                    throw new ServicesException("A query with at least one specified minute amount is required.");
                }
                if (this.contoursMinutes.length >= 2) {
                    for (int x = 0; x < this.contoursMinutes.length - 1; ++x) {
                        if (this.contoursMinutes[x] <= this.contoursMinutes[x + 1]) continue;
                        throw new ServicesException("The minutes must be listed in order from the lowest number to the highest number.");
                    }
                }
                this.contoursMinutes(TextUtils.join((CharSequence)",", (Object[])this.contoursMinutes));
            }
            if (this.contoursColors != null) {
                this.contoursColors(TextUtils.join((CharSequence)",", (Object[])this.contoursColors));
            }
            if (this.contoursColors != null && this.contoursMinutes != null && this.contoursColors.length != this.contoursMinutes.length) {
                throw new ServicesException("Number of color elements must match number of minute elements provided.");
            }
            NbmapIsochrone isochrone = this.autoBuild();
            if (!NbmapUtils.isAccessTokenValid((String)isochrone.accessToken())) {
                throw new ServicesException("Using the Nbmap Isochrone API requires setting a valid access token.");
            }
            if (TextUtils.isEmpty((CharSequence)isochrone.coordinates())) {
                throw new ServicesException("A query with longitude and latitude values is required.");
            }
            if (TextUtils.isEmpty((CharSequence)isochrone.profile())) {
                throw new ServicesException("A query with a set Directions profile (cycling, walking, or driving) is required.");
            }
            if (TextUtils.isEmpty((CharSequence)isochrone.contoursMinutes())) {
                throw new ServicesException("A query with at least one specified minute amount is required.");
            }
            if (isochrone.contoursColors() != null && isochrone.contoursColors().contains("#")) {
                throw new ServicesException("Make sure that none of the contour color HEX values have a # in front of it. Provide a list of the HEX values without any # symbols.");
            }
            return isochrone;
        }
    }
}

