/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.matching.v5;

import com.nbmap.api.directions.v5.models.RouteOptions;
import com.nbmap.api.directions.v5.utils.ParseUtils;
import com.nbmap.api.matching.v5.NbmapMapMatching;
import com.nbmap.api.matching.v5.models.MapMatchingMatching;
import com.nbmap.api.matching.v5.models.MapMatchingResponse;
import com.nbmap.geojson.Point;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Response;

class MatchingResponseFactory {
    private static final String PLACEHOLDER_UUID = "mapmatching";
    private final NbmapMapMatching nbmapMapMatching;

    MatchingResponseFactory(NbmapMapMatching nbmapMapMatching) {
        this.nbmapMapMatching = nbmapMapMatching;
    }

    retrofit2.Response<MapMatchingResponse> generate(retrofit2.Response<MapMatchingResponse> response) {
        if (this.isNotSuccessful(response)) {
            return response;
        }
        return retrofit2.Response.success((Object)((MapMatchingResponse)response.body()).toBuilder().matchings(this.generateRouteOptions(response)).build(), (Response)new Response.Builder().code(200).message("OK").protocol(response.raw().protocol()).headers(response.headers()).request(response.raw().request()).build());
    }

    private boolean isNotSuccessful(retrofit2.Response<MapMatchingResponse> response) {
        return !response.isSuccessful() || response.body() == null || ((MapMatchingResponse)response.body()).matchings() == null || ((MapMatchingResponse)response.body()).matchings().isEmpty();
    }

    private List<MapMatchingMatching> generateRouteOptions(retrofit2.Response<MapMatchingResponse> response) {
        List<MapMatchingMatching> matchings = ((MapMatchingResponse)response.body()).matchings();
        ArrayList<MapMatchingMatching> modifiedMatchings = new ArrayList<MapMatchingMatching>();
        for (MapMatchingMatching matching : matchings) {
            modifiedMatchings.add(matching.toBuilder().routeOptions(RouteOptions.builder().profile(this.nbmapMapMatching.profile()).coordinates(MatchingResponseFactory.formatCoordinates(this.nbmapMapMatching.coordinates())).annotations(this.nbmapMapMatching.annotations()).approachesList(ParseUtils.parseToStrings((String)this.nbmapMapMatching.approaches())).language(this.nbmapMapMatching.language()).radiusesList(ParseUtils.parseToDoubles((String)this.nbmapMapMatching.radiuses())).user(this.nbmapMapMatching.user()).voiceInstructions(this.nbmapMapMatching.voiceInstructions()).bannerInstructions(this.nbmapMapMatching.bannerInstructions()).roundaboutExits(this.nbmapMapMatching.roundaboutExits()).geometries(this.nbmapMapMatching.geometries()).overview(this.nbmapMapMatching.overview()).steps(this.nbmapMapMatching.steps()).voiceUnits(this.nbmapMapMatching.voiceUnits()).requestUuid(PLACEHOLDER_UUID).accessToken(this.nbmapMapMatching.accessToken()).waypointIndicesList(ParseUtils.parseToIntegers((String)this.nbmapMapMatching.waypointIndices())).waypointNamesList(ParseUtils.parseToStrings((String)this.nbmapMapMatching.waypointNames())).baseUrl(this.nbmapMapMatching.baseUrl()).build()).build());
        }
        return modifiedMatchings;
    }

    private static List<Point> formatCoordinates(String coordinates) {
        String[] coordPairs = coordinates.split(";", -1);
        ArrayList<Point> coordinatesFormatted = new ArrayList<Point>();
        for (String coordPair : coordPairs) {
            String[] coords = coordPair.split(",", -1);
            coordinatesFormatted.add(Point.fromLngLat((double)Double.valueOf(coords[0]), (double)Double.valueOf(coords[1])));
        }
        return coordinatesFormatted;
    }
}

