/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.matrix.v1;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.nbmap.api.directions.v5.DirectionsAdapterFactory;
import com.nbmap.api.directions.v5.DirectionsCriteria;
import com.nbmap.api.directions.v5.utils.FormatUtils;
import com.nbmap.api.matrix.v1.AutoValue_NbmapMatrix;
import com.nbmap.api.matrix.v1.MatrixAdapterFactory;
import com.nbmap.api.matrix.v1.MatrixService;
import com.nbmap.api.matrix.v1.models.MatrixResponse;
import com.nbmap.core.NbmapService;
import com.nbmap.core.exceptions.ServicesException;
import com.nbmap.core.utils.ApiCallHelper;
import com.nbmap.core.utils.NbmapUtils;
import com.nbmap.core.utils.TextUtils;
import com.nbmap.geojson.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;

@AutoValue
public abstract class NbmapMatrix
extends NbmapService<MatrixResponse, MatrixService> {
    protected NbmapMatrix() {
        super(MatrixService.class);
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(MatrixAdapterFactory.create()).registerTypeAdapterFactory(DirectionsAdapterFactory.create());
    }

    protected Call<MatrixResponse> initializeCall() {
        return ((MatrixService)this.getService()).getCall(ApiCallHelper.getHeaderUserAgent((String)this.clientAppName()), this.user(), this.profile(), this.coordinates(), this.accessToken(), this.annotations(), this.approaches(), this.destinations(), this.sources());
    }

    @Nullable
    abstract String clientAppName();

    @NonNull
    abstract String user();

    @NonNull
    abstract String coordinates();

    @NonNull
    abstract String accessToken();

    @NonNull
    abstract String profile();

    @Nullable
    abstract String sources();

    @Nullable
    abstract String annotations();

    @Nullable
    abstract String approaches();

    @Nullable
    abstract String destinations();

    @NonNull
    protected abstract String baseUrl();

    public static Builder builder() {
        return new AutoValue_NbmapMatrix.Builder().baseUrl("https://api.nextbillion.io").profile("driving").user("nbmap");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        private List<Point> coordinates = new ArrayList<Point>();
        private String[] annotations;
        private String[] approaches;
        private Integer[] destinations;
        private Integer[] sources;
        private Integer coordinateListSizeLimit;

        public abstract Builder user(String var1);

        public Builder coordinates(List<Point> coordinates) {
            this.coordinates.addAll(coordinates);
            return this;
        }

        abstract Builder coordinates(@NonNull String var1);

        public Builder coordinate(@NonNull Point coordinate) {
            this.coordinates.add(coordinate);
            return this;
        }

        public abstract Builder profile(@NonNull @DirectionsCriteria.ProfileCriteria String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public Builder addAnnotations(String ... annotations) {
            this.annotations = annotations;
            return this;
        }

        abstract Builder annotations(@Nullable String var1);

        public Builder addApproaches(String ... approaches) {
            this.approaches = approaches;
            return this;
        }

        abstract Builder approaches(@Nullable @DirectionsCriteria.ApproachesCriteria String var1);

        public Builder destinations(Integer ... destinations) {
            this.destinations = destinations;
            return this;
        }

        abstract Builder destinations(@Nullable String var1);

        public Builder sources(Integer ... sources) {
            this.sources = sources;
            return this;
        }

        abstract Builder sources(@Nullable String var1);

        public abstract Builder clientAppName(@NonNull String var1);

        public abstract Builder baseUrl(@NonNull String var1);

        public Builder coordinateListSizeLimit(@NonNull Integer coordinateListSizeLimit) {
            this.coordinateListSizeLimit = coordinateListSizeLimit;
            return this;
        }

        abstract NbmapMatrix autoBuild();

        public NbmapMatrix build() {
            if (this.coordinates == null || this.coordinates.size() < 2) {
                throw new ServicesException("At least two coordinates must be provided with your API request.");
            }
            if (this.coordinateListSizeLimit != null && this.coordinateListSizeLimit < 0) {
                throw new ServicesException("If you're going to use the coordinateListSizeLimit() method, please pass through a number that's greater than zero.");
            }
            if (this.coordinateListSizeLimit == null && this.coordinates.size() > 25) {
                throw new ServicesException("A maximum of 25 coordinates is the default  allowed for this API. If your Nbmap account has been enabled by the Nbmap team to make a request with more than 25 coordinates, please use the builder's coordinateListSizeLimit() method and pass through your account-specific maximum.");
            }
            if (this.coordinateListSizeLimit != null && this.coordinateListSizeLimit < this.coordinates.size()) {
                throw new ServicesException("If you're going to use the coordinateListSizeLimit() method, please pass through a number that's equal to or greater than the size of your coordinate list.");
            }
            this.coordinates(Builder.formatCoordinates(this.coordinates));
            this.sources(TextUtils.join((CharSequence)";", (Object[])this.sources));
            this.destinations(TextUtils.join((CharSequence)";", (Object[])this.destinations));
            this.annotations(TextUtils.join((CharSequence)",", (Object[])this.annotations));
            this.approaches(TextUtils.join((CharSequence)";", (Object[])this.approaches));
            NbmapMatrix matrix = this.autoBuild();
            if (!NbmapUtils.isAccessTokenValid((String)matrix.accessToken())) {
                throw new ServicesException("Using Nbmap Services requires setting a valid access token.");
            }
            return matrix;
        }

        private static String formatCoordinates(List<Point> coordinates) {
            ArrayList<String> coordinatesFormatted = new ArrayList<String>();
            for (Point point : coordinates) {
                coordinatesFormatted.add(String.format(Locale.US, "%s,%s", FormatUtils.formatCoordinate((double)point.longitude()), FormatUtils.formatCoordinate((double)point.latitude())));
            }
            return TextUtils.join((CharSequence)";", (Object[])coordinatesFormatted.toArray());
        }
    }
}

