/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.speech.v1;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.nbmap.api.speech.v1.AutoValue_NbmapSpeech;
import com.nbmap.api.speech.v1.SpeechService;
import com.nbmap.core.NbmapService;
import com.nbmap.core.exceptions.ServicesException;
import com.nbmap.core.utils.TextUtils;
import java.util.logging.Logger;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import okhttp3.logging.HttpLoggingInterceptor;
import retrofit2.Call;

@AutoValue
public abstract class NbmapSpeech
extends NbmapService<ResponseBody, SpeechService> {
    private static final Logger LOGGER = Logger.getLogger(NbmapSpeech.class.getName());

    protected NbmapSpeech() {
        super(SpeechService.class);
    }

    protected Call<ResponseBody> initializeCall() {
        return ((SpeechService)this.getService()).getCall(this.instruction(), this.textType(), this.language(), this.outputType(), this.accessToken());
    }

    @Nullable
    abstract String language();

    @Nullable
    abstract String textType();

    @Nullable
    abstract String outputType();

    @Nullable
    abstract Cache cache();

    @Nullable
    abstract Interceptor interceptor();

    @Nullable
    abstract Interceptor networkInterceptor();

    @NonNull
    abstract String accessToken();

    @NonNull
    abstract String instruction();

    protected abstract String baseUrl();

    public synchronized OkHttpClient getOkHttpClient() {
        if (this.okHttpClient == null) {
            OkHttpClient.Builder httpClient = new OkHttpClient.Builder();
            if (this.isEnableDebug()) {
                HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
                logging.setLevel(HttpLoggingInterceptor.Level.BASIC);
                httpClient.addInterceptor((Interceptor)logging);
            }
            if (this.cache() != null) {
                httpClient.cache(this.cache());
            }
            if (this.interceptor() != null) {
                httpClient.addInterceptor(this.interceptor());
            }
            if (this.networkInterceptor() != null) {
                httpClient.addNetworkInterceptor(this.networkInterceptor());
            }
            this.okHttpClient = httpClient.build();
        }
        return this.okHttpClient;
    }

    public static Builder builder() {
        return new AutoValue_NbmapSpeech.Builder().baseUrl("https://api.nextbillion.io");
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder language(String var1);

        public abstract Builder textType(String var1);

        public abstract Builder outputType(String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder instruction(@NonNull String var1);

        public abstract Builder baseUrl(@NonNull String var1);

        public abstract Builder cache(Cache var1);

        public abstract Builder interceptor(Interceptor var1);

        public abstract Builder networkInterceptor(Interceptor var1);

        abstract NbmapSpeech autoBuild();

        public NbmapSpeech build() {
            NbmapSpeech nbmapSpeech = this.autoBuild();
            if (TextUtils.isEmpty((CharSequence)nbmapSpeech.instruction())) {
                throw new ServicesException("Non-null, non-empty instruction text is required.");
            }
            return nbmapSpeech;
        }
    }
}

