/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.staticmap.v1;

import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.nbmap.api.staticmap.v1.AutoValue_NbmapStaticMap;
import com.nbmap.api.staticmap.v1.models.StaticMarkerAnnotation;
import com.nbmap.api.staticmap.v1.models.StaticPolylineAnnotation;
import com.nbmap.core.exceptions.ServicesException;
import com.nbmap.core.utils.NbmapUtils;
import com.nbmap.core.utils.TextUtils;
import com.nbmap.geojson.GeoJson;
import com.nbmap.geojson.Point;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import okhttp3.HttpUrl;

@AutoValue
public abstract class NbmapStaticMap {
    private static final String BEFORE_LAYER = "before_layer";
    private static final String CAMERA_AUTO = "auto";

    @NonNull
    abstract String accessToken();

    @NonNull
    abstract String baseUrl();

    @NonNull
    abstract String user();

    @NonNull
    abstract String styleId();

    abstract boolean logo();

    abstract boolean attribution();

    abstract boolean retina();

    @NonNull
    abstract Point cameraPoint();

    abstract double cameraZoom();

    abstract double cameraBearing();

    abstract double cameraPitch();

    abstract boolean cameraAuto();

    @Nullable
    abstract String beforeLayer();

    abstract int width();

    abstract int height();

    @Nullable
    abstract GeoJson geoJson();

    @Nullable
    abstract List<StaticMarkerAnnotation> staticMarkerAnnotations();

    @Nullable
    abstract List<StaticPolylineAnnotation> staticPolylineAnnotations();

    abstract int precision();

    public HttpUrl url() {
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)this.baseUrl()).newBuilder().addPathSegment("styles").addPathSegment("v1").addPathSegment(this.user()).addPathSegment(this.styleId()).addPathSegment("static").addQueryParameter("access_token", this.accessToken());
        ArrayList annotations = new ArrayList();
        if (this.staticMarkerAnnotations() != null) {
            ArrayList<String> markerStrings = new ArrayList<String>(this.staticMarkerAnnotations().size());
            for (StaticMarkerAnnotation marker : this.staticMarkerAnnotations()) {
                markerStrings.add(marker.url());
            }
            annotations.addAll(markerStrings);
        }
        if (this.staticPolylineAnnotations() != null) {
            String[] polylineStringArray = new String[this.staticPolylineAnnotations().size()];
            for (StaticPolylineAnnotation polyline : this.staticPolylineAnnotations()) {
                polylineStringArray[this.staticPolylineAnnotations().indexOf((Object)polyline)] = polyline.url();
            }
            annotations.addAll(Arrays.asList(polylineStringArray));
        }
        if (this.geoJson() != null) {
            annotations.add(String.format(Locale.US, "geojson(%s)", this.geoJson().toJson()));
        }
        if (!annotations.isEmpty()) {
            urlBuilder.addPathSegment(TextUtils.join((CharSequence)",", (Object[])annotations.toArray()));
        }
        urlBuilder.addPathSegment(this.cameraAuto() ? CAMERA_AUTO : this.generateLocationPathSegment());
        if (this.beforeLayer() != null) {
            urlBuilder.addQueryParameter(BEFORE_LAYER, this.beforeLayer());
        }
        if (!this.attribution()) {
            urlBuilder.addQueryParameter("attribution", "false");
        }
        if (!this.logo()) {
            urlBuilder.addQueryParameter("logo", "false");
        }
        urlBuilder.addPathSegment(this.generateSizePathSegment());
        return urlBuilder.build();
    }

    private String generateLocationPathSegment() {
        if (this.precision() > 0) {
            ArrayList<String> geoInfo = new ArrayList<String>();
            geoInfo.add(TextUtils.formatCoordinate((double)this.cameraPoint().longitude(), (int)this.precision()));
            geoInfo.add(TextUtils.formatCoordinate((double)this.cameraPoint().latitude(), (int)this.precision()));
            geoInfo.add(TextUtils.formatCoordinate((double)this.cameraZoom(), (int)this.precision()));
            geoInfo.add(TextUtils.formatCoordinate((double)this.cameraBearing(), (int)this.precision()));
            geoInfo.add(TextUtils.formatCoordinate((double)this.cameraPitch(), (int)this.precision()));
            return TextUtils.join((CharSequence)",", (Object[])geoInfo.toArray());
        }
        return String.format(Locale.US, "%f,%f,%f,%f,%f", this.cameraPoint().longitude(), this.cameraPoint().latitude(), this.cameraZoom(), this.cameraBearing(), this.cameraPitch());
    }

    private String generateSizePathSegment() {
        return String.format(Locale.US, "%dx%d%s", this.width(), this.height(), this.retina() ? "@2x" : "");
    }

    public static Builder builder() {
        return new AutoValue_NbmapStaticMap.Builder().styleId("streets-v11").baseUrl("https://api.nextbillion.io").user("nbmap").cameraPoint(Point.fromLngLat((double)0.0, (double)0.0)).cameraAuto(false).attribution(true).width(250).logo(true).attribution(true).retina(true).height(250).cameraZoom(0.0).cameraPitch(0.0).cameraBearing(0.0).precision(0).retina(false);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder baseUrl(@NonNull String var1);

        public abstract Builder user(@NonNull String var1);

        public abstract Builder styleId(@NonNull String var1);

        public abstract Builder logo(boolean var1);

        public abstract Builder attribution(boolean var1);

        public abstract Builder retina(boolean var1);

        public abstract Builder cameraPoint(@Nullable Point var1);

        public abstract Builder cameraZoom(@FloatRange(from=0.0, to=22.0) double var1);

        public abstract Builder cameraBearing(@FloatRange(from=0.0, to=360.0) double var1);

        public abstract Builder cameraPitch(@FloatRange(from=0.0, to=60.0) double var1);

        public abstract Builder cameraAuto(boolean var1);

        public abstract Builder beforeLayer(@Nullable String var1);

        public abstract Builder width(@IntRange(from=1L, to=1280L) int var1);

        public abstract Builder height(@IntRange(from=1L, to=1280L) int var1);

        public abstract Builder geoJson(@Nullable GeoJson var1);

        public abstract Builder staticMarkerAnnotations(@Nullable List<StaticMarkerAnnotation> var1);

        public abstract Builder staticPolylineAnnotations(@Nullable List<StaticPolylineAnnotation> var1);

        public abstract Builder precision(@IntRange(from=0L) int var1);

        abstract NbmapStaticMap autoBuild();

        public NbmapStaticMap build() {
            NbmapStaticMap staticMap = this.autoBuild();
            if (!NbmapUtils.isAccessTokenValid((String)staticMap.accessToken())) {
                throw new ServicesException("Using Nbmap Services requires setting a valid access token.");
            }
            if (staticMap.styleId().isEmpty()) {
                throw new ServicesException("You need to set a map style.");
            }
            return staticMap;
        }
    }
}

