/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.api.tilequery;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import com.nbmap.api.tilequery.AutoValue_NbmapTilequery;
import com.nbmap.api.tilequery.TilequeryCriteria;
import com.nbmap.api.tilequery.TilequeryService;
import com.nbmap.core.NbmapService;
import com.nbmap.core.exceptions.ServicesException;
import com.nbmap.core.utils.NbmapUtils;
import com.nbmap.core.utils.TextUtils;
import com.nbmap.geojson.FeatureCollection;
import com.nbmap.geojson.GeometryAdapterFactory;
import com.nbmap.geojson.Point;
import com.nbmap.geojson.gson.GeoJsonAdapterFactory;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

@AutoValue
public abstract class NbmapTilequery
extends NbmapService<FeatureCollection, TilequeryService> {
    private Call<List<FeatureCollection>> batchCall;

    protected NbmapTilequery() {
        super(TilequeryService.class);
    }

    protected GsonBuilder getGsonBuilder() {
        return new GsonBuilder().registerTypeAdapterFactory(GeoJsonAdapterFactory.create()).registerTypeAdapterFactory(GeometryAdapterFactory.create());
    }

    protected Call<FeatureCollection> initializeCall() {
        return ((TilequeryService)this.getService()).getCall(this.tilesetIds(), this.query(), this.accessToken(), this.radius(), this.limit(), this.dedupe(), this.geometry(), this.layers());
    }

    private Call<List<FeatureCollection>> getBatchCall() {
        if (this.batchCall != null) {
            return this.batchCall;
        }
        this.batchCall = ((TilequeryService)this.getService()).getBatchCall(this.tilesetIds(), this.query(), this.accessToken(), this.radius(), this.limit(), this.dedupe(), this.geometry(), this.layers());
        return this.batchCall;
    }

    public Response<List<FeatureCollection>> executeBatchCall() throws IOException {
        return this.getBatchCall().execute();
    }

    public void enqueueBatchCall(Callback<List<FeatureCollection>> callback) {
        this.getBatchCall().enqueue(callback);
    }

    public void cancelBatchCall() {
        this.getBatchCall().cancel();
    }

    public Call<List<FeatureCollection>> cloneBatchCall() {
        return this.getBatchCall().clone();
    }

    public static Builder builder() {
        return new AutoValue_NbmapTilequery.Builder().baseUrl("https://api.nextbillion.io");
    }

    @NonNull
    protected abstract String baseUrl();

    @NonNull
    abstract String accessToken();

    @NonNull
    abstract String tilesetIds();

    @NonNull
    abstract String query();

    @Nullable
    abstract Integer radius();

    @Nullable
    abstract Integer limit();

    @Nullable
    abstract Boolean dedupe();

    @Nullable
    @TilequeryCriteria.TilequeryGeometry
    abstract String geometry();

    @Nullable
    abstract String layers();

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder baseUrl(@NonNull String var1);

        public abstract Builder accessToken(@NonNull String var1);

        public abstract Builder tilesetIds(String var1);

        public Builder query(@NonNull Point point) {
            this.query(String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)point.longitude()), TextUtils.formatCoordinate((double)point.latitude())));
            String str = String.format(Locale.US, "%s,%s", TextUtils.formatCoordinate((double)point.longitude()), TextUtils.formatCoordinate((double)point.latitude()));
            return this;
        }

        public abstract Builder query(@NonNull String var1);

        public abstract Builder radius(@Nullable Integer var1);

        public abstract Builder limit(@Nullable Integer var1);

        public abstract Builder dedupe(@Nullable Boolean var1);

        public abstract Builder geometry(@Nullable @TilequeryCriteria.TilequeryGeometry String var1);

        public abstract Builder layers(@Nullable String var1);

        abstract NbmapTilequery autoBuild();

        public NbmapTilequery build() {
            NbmapTilequery tilequery = this.autoBuild();
            if (!NbmapUtils.isAccessTokenValid((String)tilequery.accessToken())) {
                throw new ServicesException("Using Nbmap Services requires setting a valid access token.");
            }
            if (tilequery.query().isEmpty()) {
                throw new ServicesException("A query with latitude and longitude values is required.");
            }
            return tilequery;
        }
    }
}

