/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.turf;

import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonObject;
import com.nbmap.geojson.BoundingBox;
import com.nbmap.geojson.Feature;
import com.nbmap.geojson.FeatureCollection;
import com.nbmap.geojson.GeoJson;
import com.nbmap.geojson.Geometry;
import com.nbmap.geojson.GeometryCollection;
import com.nbmap.geojson.LineString;
import com.nbmap.geojson.MultiLineString;
import com.nbmap.geojson.MultiPoint;
import com.nbmap.geojson.MultiPolygon;
import com.nbmap.geojson.Point;
import com.nbmap.geojson.Polygon;
import com.nbmap.turf.TurfConstants;
import com.nbmap.turf.TurfConversion;
import com.nbmap.turf.TurfMeta;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class TurfMeasurement {
    public static double EARTH_RADIUS = 6378137.0;

    private TurfMeasurement() {
        throw new AssertionError((Object)"No Instances.");
    }

    public static double bearing(@NonNull Point point1, @NonNull Point point2) {
        double lon1 = TurfConversion.degreesToRadians(point1.longitude());
        double lon2 = TurfConversion.degreesToRadians(point2.longitude());
        double lat1 = TurfConversion.degreesToRadians(point1.latitude());
        double lat2 = TurfConversion.degreesToRadians(point2.latitude());
        double value1 = Math.sin(lon2 - lon1) * Math.cos(lat2);
        double value2 = Math.cos(lat1) * Math.sin(lat2) - Math.sin(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1);
        return TurfConversion.radiansToDegrees(Math.atan2(value1, value2));
    }

    @NonNull
    public static Point destination(@NonNull Point point, @FloatRange(from=0.0) double distance, @FloatRange(from=-180.0, to=180.0) double bearing, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        double longitude1 = TurfConversion.degreesToRadians(point.longitude());
        double latitude1 = TurfConversion.degreesToRadians(point.latitude());
        double bearingRad = TurfConversion.degreesToRadians(bearing);
        double radians = TurfConversion.lengthToRadians(distance, units);
        double latitude2 = Math.asin(Math.sin(latitude1) * Math.cos(radians) + Math.cos(latitude1) * Math.sin(radians) * Math.cos(bearingRad));
        double longitude2 = longitude1 + Math.atan2(Math.sin(bearingRad) * Math.sin(radians) * Math.cos(latitude1), Math.cos(radians) - Math.sin(latitude1) * Math.sin(latitude2));
        return Point.fromLngLat((double)TurfConversion.radiansToDegrees(longitude2), (double)TurfConversion.radiansToDegrees(latitude2));
    }

    public static double distance(@NonNull Point point1, @NonNull Point point2) {
        return TurfMeasurement.distance(point1, point2, "kilometers");
    }

    public static double distance(@NonNull Point point1, @NonNull Point point2, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        double difLat = TurfConversion.degreesToRadians(point2.latitude() - point1.latitude());
        double difLon = TurfConversion.degreesToRadians(point2.longitude() - point1.longitude());
        double lat1 = TurfConversion.degreesToRadians(point1.latitude());
        double lat2 = TurfConversion.degreesToRadians(point2.latitude());
        double value = Math.pow(Math.sin(difLat / 2.0), 2.0) + Math.pow(Math.sin(difLon / 2.0), 2.0) * Math.cos(lat1) * Math.cos(lat2);
        return TurfConversion.radiansToLength(2.0 * Math.atan2(Math.sqrt(value), Math.sqrt(1.0 - value)), units);
    }

    public static double length(@NonNull LineString lineString, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        List coordinates = lineString.coordinates();
        return TurfMeasurement.length(coordinates, units);
    }

    public static double length(@NonNull MultiLineString multiLineString, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        double len = 0.0;
        for (List points : multiLineString.coordinates()) {
            len += TurfMeasurement.length(points, units);
        }
        return len;
    }

    public static double length(@NonNull Polygon polygon, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        double len = 0.0;
        for (List points : polygon.coordinates()) {
            len += TurfMeasurement.length(points, units);
        }
        return len;
    }

    public static double length(@NonNull MultiPolygon multiPolygon, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        double len = 0.0;
        List coordinates = multiPolygon.coordinates();
        for (List coordinate : coordinates) {
            for (List theCoordinate : coordinate) {
                len += TurfMeasurement.length(theCoordinate, units);
            }
        }
        return len;
    }

    public static double length(List<Point> coords, String units) {
        double travelled = 0.0;
        Point prevCoords = coords.get(0);
        for (int i = 1; i < coords.size(); ++i) {
            Point curCoords = coords.get(i);
            travelled += TurfMeasurement.distance(prevCoords, curCoords, units);
            prevCoords = curCoords;
        }
        return travelled;
    }

    public static Point midpoint(@NonNull Point from, @NonNull Point to) {
        double dist = TurfMeasurement.distance(from, to, "miles");
        double heading = TurfMeasurement.bearing(from, to);
        return TurfMeasurement.destination(from, dist / 2.0, heading, "miles");
    }

    public static Point along(@NonNull LineString line, @FloatRange(from=0.0) double distance, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        return TurfMeasurement.along(line.coordinates(), distance, units);
    }

    public static Point along(@NonNull List<Point> coords, @FloatRange(from=0.0) double distance, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        double travelled = 0.0;
        for (int i = 0; !(i >= coords.size() || distance >= travelled && i == coords.size() - 1); travelled += TurfMeasurement.distance(coords.get(i), coords.get(i + 1), units), ++i) {
            if (!(travelled >= distance)) continue;
            double overshot = distance - travelled;
            if (overshot == 0.0) {
                return coords.get(i);
            }
            double direction = TurfMeasurement.bearing(coords.get(i), coords.get(i - 1)) - 180.0;
            return TurfMeasurement.destination(coords.get(i), overshot, direction, units);
        }
        return coords.get(coords.size() - 1);
    }

    public static double[] bbox(@NonNull Point point) {
        List<Point> resultCoords = TurfMeta.coordAll(point);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(@NonNull LineString lineString) {
        List<Point> resultCoords = TurfMeta.coordAll(lineString);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(@NonNull MultiPoint multiPoint) {
        List<Point> resultCoords = TurfMeta.coordAll(multiPoint);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(@NonNull Polygon polygon) {
        List<Point> resultCoords = TurfMeta.coordAll(polygon, false);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(@NonNull MultiLineString multiLineString) {
        List<Point> resultCoords = TurfMeta.coordAll(multiLineString);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(MultiPolygon multiPolygon) {
        List<Point> resultCoords = TurfMeta.coordAll(multiPolygon, false);
        return TurfMeasurement.bboxCalculator(resultCoords);
    }

    public static double[] bbox(GeoJson geoJson) {
        BoundingBox boundingBox = geoJson.bbox();
        if (boundingBox != null) {
            return new double[]{boundingBox.west(), boundingBox.south(), boundingBox.east(), boundingBox.north()};
        }
        if (geoJson instanceof Geometry) {
            return TurfMeasurement.bbox((Geometry)geoJson);
        }
        if (geoJson instanceof FeatureCollection) {
            return TurfMeasurement.bbox((FeatureCollection)geoJson);
        }
        if (geoJson instanceof Feature) {
            return TurfMeasurement.bbox((Feature)geoJson);
        }
        throw new UnsupportedOperationException("bbox type not supported for GeoJson instance");
    }

    public static double[] bbox(FeatureCollection featureCollection) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(featureCollection, false));
    }

    public static double[] bbox(Feature feature) {
        return TurfMeasurement.bboxCalculator(TurfMeta.coordAll(feature, false));
    }

    public static double[] bbox(Geometry geometry) {
        if (geometry instanceof Point) {
            return TurfMeasurement.bbox((Point)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return TurfMeasurement.bbox((MultiPoint)geometry);
        }
        if (geometry instanceof LineString) {
            return TurfMeasurement.bbox((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return TurfMeasurement.bbox((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return TurfMeasurement.bbox((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return TurfMeasurement.bbox((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            ArrayList<Point> points = new ArrayList<Point>();
            for (Geometry geo : ((GeometryCollection)geometry).geometries()) {
                double[] bbox = TurfMeasurement.bbox(geo);
                points.add(Point.fromLngLat((double)bbox[0], (double)bbox[1]));
                points.add(Point.fromLngLat((double)bbox[2], (double)bbox[1]));
                points.add(Point.fromLngLat((double)bbox[2], (double)bbox[3]));
                points.add(Point.fromLngLat((double)bbox[0], (double)bbox[3]));
            }
            return TurfMeasurement.bbox(MultiPoint.fromLngLats(points));
        }
        throw new RuntimeException("Unknown geometry class: " + geometry.getClass());
    }

    private static double[] bboxCalculator(List<Point> resultCoords) {
        double[] bbox = new double[]{Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        for (Point point : resultCoords) {
            if (bbox[0] > point.longitude()) {
                bbox[0] = point.longitude();
            }
            if (bbox[1] > point.latitude()) {
                bbox[1] = point.latitude();
            }
            if (bbox[2] < point.longitude()) {
                bbox[2] = point.longitude();
            }
            if (!(bbox[3] < point.latitude())) continue;
            bbox[3] = point.latitude();
        }
        return bbox;
    }

    public static Feature bboxPolygon(@NonNull BoundingBox boundingBox) {
        return TurfMeasurement.bboxPolygon(boundingBox, null, null);
    }

    public static Feature bboxPolygon(@NonNull BoundingBox boundingBox, @Nullable JsonObject properties, @Nullable String id) {
        return Feature.fromGeometry((Geometry)Polygon.fromLngLats(Collections.singletonList(Arrays.asList(Point.fromLngLat((double)boundingBox.west(), (double)boundingBox.south()), Point.fromLngLat((double)boundingBox.east(), (double)boundingBox.south()), Point.fromLngLat((double)boundingBox.east(), (double)boundingBox.north()), Point.fromLngLat((double)boundingBox.west(), (double)boundingBox.north()), Point.fromLngLat((double)boundingBox.west(), (double)boundingBox.south())))), (JsonObject)properties, (String)id);
    }

    public static Feature bboxPolygon(@NonNull double[] bbox) {
        return TurfMeasurement.bboxPolygon(bbox, null, null);
    }

    public static Feature bboxPolygon(@NonNull double[] bbox, @Nullable JsonObject properties, @Nullable String id) {
        return Feature.fromGeometry((Geometry)Polygon.fromLngLats(Collections.singletonList(Arrays.asList(Point.fromLngLat((double)bbox[0], (double)bbox[1]), Point.fromLngLat((double)bbox[2], (double)bbox[1]), Point.fromLngLat((double)bbox[2], (double)bbox[3]), Point.fromLngLat((double)bbox[0], (double)bbox[3]), Point.fromLngLat((double)bbox[0], (double)bbox[1])))), (JsonObject)properties, (String)id);
    }

    public static Polygon envelope(GeoJson geoJson) {
        return (Polygon)TurfMeasurement.bboxPolygon(TurfMeasurement.bbox(geoJson)).geometry();
    }

    public static BoundingBox square(@NonNull BoundingBox boundingBox) {
        double verticalDistance;
        double horizontalDistance = TurfMeasurement.distance(boundingBox.southwest(), Point.fromLngLat((double)boundingBox.east(), (double)boundingBox.south()));
        if (horizontalDistance >= (verticalDistance = TurfMeasurement.distance(Point.fromLngLat((double)boundingBox.west(), (double)boundingBox.south()), Point.fromLngLat((double)boundingBox.west(), (double)boundingBox.north())))) {
            double verticalMidpoint = (boundingBox.south() + boundingBox.north()) / 2.0;
            return BoundingBox.fromLngLats((double)boundingBox.west(), (double)(verticalMidpoint - (boundingBox.east() - boundingBox.west()) / 2.0), (double)boundingBox.east(), (double)(verticalMidpoint + (boundingBox.east() - boundingBox.west()) / 2.0));
        }
        double horizontalMidpoint = (boundingBox.west() + boundingBox.east()) / 2.0;
        return BoundingBox.fromLngLats((double)(horizontalMidpoint - (boundingBox.north() - boundingBox.south()) / 2.0), (double)boundingBox.south(), (double)(horizontalMidpoint + (boundingBox.north() - boundingBox.south()) / 2.0), (double)boundingBox.north());
    }

    public static double area(@NonNull Feature feature) {
        return feature.geometry() != null ? TurfMeasurement.area(feature.geometry()) : 0.0;
    }

    public static double area(@NonNull FeatureCollection featureCollection) {
        List features = featureCollection.features();
        double total = 0.0;
        if (features != null) {
            for (Feature feature : features) {
                total += TurfMeasurement.area(feature);
            }
        }
        return total;
    }

    public static double area(@NonNull Geometry geometry) {
        return TurfMeasurement.calculateArea(geometry);
    }

    private static double calculateArea(@NonNull Geometry geometry) {
        double total = 0.0;
        if (geometry instanceof Polygon) {
            return TurfMeasurement.polygonArea(((Polygon)geometry).coordinates());
        }
        if (geometry instanceof MultiPolygon) {
            List coordinates = ((MultiPolygon)geometry).coordinates();
            for (int i = 0; i < coordinates.size(); ++i) {
                total += TurfMeasurement.polygonArea((List)coordinates.get(i));
            }
            return total;
        }
        return 0.0;
    }

    private static double polygonArea(@NonNull List<List<Point>> coordinates) {
        double total = 0.0;
        if (coordinates.size() > 0) {
            total += Math.abs(TurfMeasurement.ringArea(coordinates.get(0)));
            for (int i = 1; i < coordinates.size(); ++i) {
                total -= Math.abs(TurfMeasurement.ringArea(coordinates.get(i)));
            }
        }
        return total;
    }

    private static double ringArea(@NonNull List<Point> coordinates) {
        double total = 0.0;
        int coordsLength = coordinates.size();
        if (coordsLength > 2) {
            for (int i = 0; i < coordsLength; ++i) {
                int upperIndex;
                int middleIndex;
                int lowerIndex;
                if (i == coordsLength - 2) {
                    lowerIndex = coordsLength - 2;
                    middleIndex = coordsLength - 1;
                    upperIndex = 0;
                } else if (i == coordsLength - 1) {
                    lowerIndex = coordsLength - 1;
                    middleIndex = 0;
                    upperIndex = 1;
                } else {
                    lowerIndex = i;
                    middleIndex = i + 1;
                    upperIndex = i + 2;
                }
                Point p1 = coordinates.get(lowerIndex);
                Point p2 = coordinates.get(middleIndex);
                Point p3 = coordinates.get(upperIndex);
                total += (TurfMeasurement.rad(p3.longitude()) - TurfMeasurement.rad(p1.longitude())) * Math.sin(TurfMeasurement.rad(p2.latitude()));
            }
            total = total * EARTH_RADIUS * EARTH_RADIUS / 2.0;
        }
        return total;
    }

    private static double rad(double num) {
        return num * Math.PI / 180.0;
    }

    public static Feature center(Feature feature, @Nullable JsonObject properties, @Nullable String id) {
        return TurfMeasurement.center(FeatureCollection.fromFeature((Feature)feature), properties, id);
    }

    public static Feature center(Feature feature) {
        return TurfMeasurement.center(FeatureCollection.fromFeature((Feature)feature), null, null);
    }

    public static Feature center(FeatureCollection featureCollection, @Nullable JsonObject properties, @Nullable String id) {
        double[] ext = TurfMeasurement.bbox(featureCollection);
        double finalCenterLongitude = (ext[0] + ext[2]) / 2.0;
        double finalCenterLatitude = (ext[1] + ext[3]) / 2.0;
        return Feature.fromGeometry((Geometry)Point.fromLngLat((double)finalCenterLongitude, (double)finalCenterLatitude), (JsonObject)properties, (String)id);
    }

    public static Feature center(FeatureCollection featureCollection) {
        return TurfMeasurement.center(featureCollection, null, null);
    }
}

