/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.turf;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import com.nbmap.geojson.Point;
import com.nbmap.geojson.Polygon;
import com.nbmap.turf.TurfConstants;
import com.nbmap.turf.TurfMeasurement;
import java.util.ArrayList;

public final class TurfTransformation {
    private static final int DEFAULT_STEPS = 64;

    private TurfTransformation() {
    }

    public static Polygon circle(@NonNull Point center, double radius) {
        return TurfTransformation.circle(center, radius, 64, "kilometers");
    }

    public static Polygon circle(@NonNull Point center, double radius, @TurfConstants.TurfUnitCriteria String units) {
        return TurfTransformation.circle(center, radius, 64, units);
    }

    public static Polygon circle(@NonNull Point center, double radius, @IntRange(from=1L) int steps, @TurfConstants.TurfUnitCriteria String units) {
        ArrayList<Object> coordinates = new ArrayList<Object>();
        for (int i = 0; i < steps; ++i) {
            coordinates.add(TurfMeasurement.destination(center, radius, (double)i * 360.0 / (double)steps, units));
        }
        if (coordinates.size() > 0) {
            coordinates.add(coordinates.get(0));
        }
        ArrayList<ArrayList<Object>> coordinate = new ArrayList<ArrayList<Object>>();
        coordinate.add(coordinates);
        return Polygon.fromLngLats(coordinate);
    }
}

