/*
 * Decompiled with CFR 0.152.
 */
package com.nbmap.turf.models;

import androidx.annotation.Nullable;

public class LineIntersectsResult {
    private final Double horizontalIntersection;
    private final Double verticalIntersection;
    private final boolean onLine1;
    private final boolean onLine2;

    private LineIntersectsResult(@Nullable Double horizontalIntersection, @Nullable Double verticalIntersection, boolean onLine1, boolean onLine2) {
        this.horizontalIntersection = horizontalIntersection;
        this.verticalIntersection = verticalIntersection;
        this.onLine1 = onLine1;
        this.onLine2 = onLine2;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Nullable
    public Double horizontalIntersection() {
        return this.horizontalIntersection;
    }

    @Nullable
    public Double verticalIntersection() {
        return this.verticalIntersection;
    }

    public boolean onLine1() {
        return this.onLine1;
    }

    public boolean onLine2() {
        return this.onLine2;
    }

    public String toString() {
        return "LineIntersectsResult{horizontalIntersection=" + this.horizontalIntersection + ", verticalIntersection=" + this.verticalIntersection + ", onLine1=" + this.onLine1 + ", onLine2=" + this.onLine2 + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LineIntersectsResult) {
            LineIntersectsResult that = (LineIntersectsResult)obj;
            return (this.horizontalIntersection == null ? that.horizontalIntersection() == null : this.horizontalIntersection.equals(that.horizontalIntersection())) && (this.verticalIntersection == null ? that.verticalIntersection() == null : this.verticalIntersection.equals(that.verticalIntersection())) && this.onLine1 == that.onLine1() && this.onLine2 == that.onLine2();
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.horizontalIntersection == null ? 0 : this.horizontalIntersection.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.verticalIntersection == null ? 0 : this.verticalIntersection.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.onLine1 ? 1231 : 1237;
        hashCode *= 1000003;
        return hashCode ^= this.onLine2 ? 1231 : 1237;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static class Builder {
        private Double horizontalIntersection;
        private Double verticalIntersection;
        private Boolean onLine1 = false;
        private Boolean onLine2 = false;

        Builder() {
        }

        private Builder(LineIntersectsResult source) {
            this.horizontalIntersection = source.horizontalIntersection();
            this.verticalIntersection = source.verticalIntersection();
            this.onLine1 = source.onLine1();
            this.onLine2 = source.onLine2();
        }

        public Builder horizontalIntersection(@Nullable Double horizontalIntersection) {
            this.horizontalIntersection = horizontalIntersection;
            return this;
        }

        public Builder verticalIntersection(@Nullable Double verticalIntersection) {
            this.verticalIntersection = verticalIntersection;
            return this;
        }

        public Builder onLine1(boolean onLine1) {
            this.onLine1 = onLine1;
            return this;
        }

        public Builder onLine2(boolean onLine2) {
            this.onLine2 = onLine2;
            return this;
        }

        public LineIntersectsResult build() {
            String missing = "";
            if (this.onLine1 == null) {
                missing = missing + " onLine1";
            }
            if (this.onLine2 == null) {
                missing = missing + " onLine2";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new LineIntersectsResult(this.horizontalIntersection, this.verticalIntersection, this.onLine1, this.onLine2);
        }
    }
}

