/*
 * Decompiled with CFR 0.152.
 */
package ai.nightfall.scan;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.TemporalAmount;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class WebhookSignatureValidator {
    private static final String SHA256 = "HmacSHA256";
    private static final TemporalAmount DEFAULT_THRESHOLD = Duration.ofMinutes(5L);
    private final TemporalAmount threshold;

    public WebhookSignatureValidator() {
        this.threshold = DEFAULT_THRESHOLD;
    }

    public WebhookSignatureValidator(TemporalAmount threshold) {
        this.threshold = threshold;
    }

    public boolean validate(String requestBody, byte[] signingSecret, String requestSignature, String requestTime) {
        Mac hmac;
        if (requestBody == null || signingSecret == null || requestSignature == null || requestTime == null) {
            return false;
        }
        Instant now = Instant.now();
        Instant reqTime = Instant.parse(requestTime);
        if (now.minus(this.threshold).isAfter(reqTime)) {
            return false;
        }
        try {
            hmac = Mac.getInstance(SHA256);
            SecretKeySpec key = new SecretKeySpec(signingSecret, SHA256);
            hmac.init(key);
        }
        catch (NoSuchAlgorithmException e) {
            return false;
        }
        catch (InvalidKeyException e) {
            return false;
        }
        String hashPayload = requestTime + ":" + requestBody;
        byte[] hashed = hmac.doFinal(hashPayload.getBytes(StandardCharsets.UTF_8));
        String hexHash = String.format("%032x", new BigInteger(hashed));
        return hexHash.equals(requestSignature);
    }
}

