/*
 * Decompiled with CFR 0.152.
 */
package ai.nightfall.scan.model;

import ai.nightfall.scan.model.Confidence;
import ai.nightfall.scan.model.ContextRule;
import ai.nightfall.scan.model.ExclusionRule;
import ai.nightfall.scan.model.Regex;
import ai.nightfall.scan.model.WordList;
import ai.nightfall.scan.model.redaction.RedactionConfig;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.UUID;

public class Detector {
    @JsonProperty(value="minConfidence")
    private Confidence minConfidence;
    @JsonProperty(value="minNumFindings")
    private int minNumFindings;
    @JsonProperty(value="detectorUUID")
    private UUID detectorUUID;
    @JsonProperty(value="displayName")
    private String displayName;
    @JsonProperty(value="detectorType")
    private String detectorType;
    @JsonProperty(value="nightfallDetector")
    private String nightfallDetector;
    @JsonProperty(value="regex")
    private Regex regex;
    @JsonProperty(value="wordList")
    private WordList wordList;
    @JsonProperty(value="contextRules")
    private List<ContextRule> contextRules;
    @JsonProperty(value="exclusionRules")
    private List<ExclusionRule> exclusionRules;
    @JsonProperty(value="redactionConfig")
    private RedactionConfig redactionConfig;

    public Detector(String nightfallDetector) {
        this.detectorType = "NIGHTFALL_DETECTOR";
        this.nightfallDetector = nightfallDetector;
    }

    public Detector(Regex regex) {
        this.detectorType = "REGEX";
        this.regex = regex;
    }

    public Detector(WordList wordList) {
        this.detectorType = "WORD_LIST";
        this.wordList = wordList;
    }

    public Detector(UUID detectorUUID) {
        this.detectorUUID = detectorUUID;
    }

    public Confidence getMinConfidence() {
        return this.minConfidence;
    }

    public void setMinConfidence(Confidence minConfidence) {
        this.minConfidence = minConfidence;
    }

    public int getMinNumFindings() {
        return this.minNumFindings;
    }

    public void setMinNumFindings(int minNumFindings) {
        this.minNumFindings = minNumFindings;
    }

    public UUID getDetectorUUID() {
        return this.detectorUUID;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDetectorType() {
        return this.detectorType;
    }

    public String getNightfallDetector() {
        return this.nightfallDetector;
    }

    public Regex getRegex() {
        return this.regex;
    }

    public WordList getWordList() {
        return this.wordList;
    }

    public List<ContextRule> getContextRules() {
        return this.contextRules;
    }

    public void setContextRules(List<ContextRule> contextRules) {
        this.contextRules = contextRules;
    }

    public List<ExclusionRule> getExclusionRules() {
        return this.exclusionRules;
    }

    public void setExclusionRules(List<ExclusionRule> exclusionRules) {
        this.exclusionRules = exclusionRules;
    }

    public RedactionConfig getRedactionConfig() {
        return this.redactionConfig;
    }

    public void setRedactionConfig(RedactionConfig redactionConfig) {
        this.redactionConfig = redactionConfig;
    }

    public String toString() {
        return "Detector{minConfidence='" + (Object)((Object)this.minConfidence) + '\'' + ", minNumFindings=" + this.minNumFindings + ", detectorUUID=" + this.detectorUUID + ", displayName='" + this.displayName + '\'' + ", detectorType='" + this.detectorType + '\'' + ", nightfallDetector='" + this.nightfallDetector + '\'' + ", regex=" + this.regex + ", wordList=" + this.wordList + ", contextRules=" + this.contextRules + ", exclusionRules=" + this.exclusionRules + ", redactionConfig=" + this.redactionConfig + '}';
    }
}

