/*
	Copyright 2017, VIA Technologies, Inc. & OLAMI Team.
	
	http://olami.ai

	Licensed under the Apache License, Version 2.0 (the "License");
	you may not use this file except in compliance with the License.
	You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

	Unless required by applicable law or agreed to in writing, software
	distributed under the License is distributed on an "AS IS" BASIS,
	WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
	See the License for the specific language governing permissions and
	limitations under the License.
*/

package ai.olami.nli;

import ai.olami.ids.IDSResult;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class DescObject {
	
	public static final int STATUS_SUCCESS = 0;
	public static final int STATUS_SELECTION_OVERFLOW = 1001;
	public static final int STATUS_NO_MATCHED_GRAMMAR = 1003;
	public static final int STATUS_INPUT_LENGTH_TOO_LONG = 1005;
	public static final int STATUS_TIMEOUT = 3001;
	public static final int STATUS_SERVER_ERROR= 3003;
	public static final int STATUS_EXCEPTION= 3004;
	
	public static final String TYPE_WEATHER = IDSResult.Types.WEATHER.getName();
	public static final String TYPE_BAIKE = IDSResult.Types.BAIKE.getName();
	public static final String TYPE_NEWS = IDSResult.Types.NEWS.getName();
	public static final String TYPE_TV_PROGRAM = IDSResult.Types.TV_PROGRAM.getName();
	public static final String TYPE_POEM = IDSResult.Types.POEM.getName();
	public static final String TYPE_JOKE = IDSResult.Types.JOKE.getName();
	public static final String TYPE_STORY = "story";
	public static final String TYPE_STOCK_MARKET = IDSResult.Types.STOCK_MARKET.getName();
	public static final String TYPE_MATH = IDSResult.Types.MATH.getName();
	public static final String TYPE_UNIT_CONVERT = IDSResult.Types.UNIT_CONVERT.getName();
	public static final String TYPE_EXCHANGE_RATE = IDSResult.Types.EXCHANGE_RATE.getName();
	public static final String TYPE_COOKING = IDSResult.Types.COOKING.getName();
	public static final String TYPE_SEARCH = "search";
	public static final String TYPE_SHOPPING = "shopping";
	
	@Expose
	@SerializedName("result")
	protected String mResult = null;
	
	/**
	 * Get a chat reply, the answer to the conversation text input.
	 * If the input text not matches any grammar you configured on the NLI system,
	 * the result will be automatically generated by OLAMI intelligent dialogue system.
	 * 
	 * @return Chat reply text.
	 */
	public String getReplyAnswer() {
		return (mResult == null) ? "" : mResult;
	}
	
	/**
	 * @return TRUE if contains chat reply.
	 */
	public boolean hasReplyAnswer() {
		return ((mResult != null) && (!mResult.equals("")));
	}
	
	@Expose
	@SerializedName("status")
	protected int mStatus = 0;
	
	/**
	 * Get the status of grammar analysis.
	 * 
	 * @return 0 if system has understood the input statements, or others for other issues.
	 */
	public int getStatus() {
		return mStatus;
	}
	
	@Expose
	@SerializedName("type")
	protected String mType = null;
	
	/**
	 * Get type name, it usually refers to the IDS module name.
	 * 
	 * @return Type name.
	 */
	public String getType() {
		return (mType == null) ? "" : mType;
	}
	
	/**
	 * @return TRUE if contains type information.
	 */
	public boolean hasType() {
		return ((mType != null) && (!mType.equals("")));
	}
	
	@Expose
	@SerializedName("url")
	protected String mURL = null;
	
	/**
	 * Get URL, it usually used in the IDS module.
	 * 
	 * @return URL.
	 */
	public String getURL() {
		return (mURL == null) ? "" : mURL;
	}
	
	/**
	 * @return TRUE if contains URL information.
	 */
	public boolean hasURL() {
		return ((mURL != null) && (!mURL.equals("")));
	}
		
	@Expose
	@SerializedName("name")
	protected String mName = null;
	
	/**
	 * Get Name information, it usually used in the IDS module.
	 * 
	 * @return Name information.
	 */
	public String getName() {
		return (mName == null) ? "" : mName;
	}
	
	/**
	 * @return TRUE if contains name information.
	 */
	public boolean hasName() {
		return ((mName != null) && (!mName.equals("")));
	}
	
	@Expose
	@SerializedName("source_currency")
	protected String mSourceCurrency = null;
	
	/**
	 * Get source currency information, it usually used in the IDS module.
	 * 
	 * @return Name information.
	 */
	public String getSourceCurrency() {
		return (mSourceCurrency == null) ? "" : mSourceCurrency;
	}
	
	/**
	 * @return TRUE if contains source currency information.
	 */
	public boolean hasSourceCurrency() {
		return ((mSourceCurrency != null) && (!mSourceCurrency.equals("")));
	}
	
}
