/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.cloudService;

import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class APIConfiguration {
    public static final int LOCALIZE_OPTION_SIMPLIFIED_CHINESE = 0;
    public static final int LOCALIZE_OPTION_TRADITIONAL_CHINESE = 1;
    public static final String API_NAME_SEG = "seg";
    public static final String API_NAME_NLI = "nli";
    public static final String API_NAME_ASR = "asr";
    protected static final String API_DOMAIN_NAME_CN = "https://cn.olami.ai";
    protected static final String API_DOMAIN_NAME_TW = "https://tw.olami.ai";
    protected static final String API_BASE_URL = "/cloudservice/api";
    private String mAppKey = null;
    private String mAppSecret = null;
    private String mApiDomainName = null;
    private String mSdkType = null;
    private int mLocalizeOption = -1;
    private Map<String, String> mSignatureMap;
    private Map<String, Long> mTimestampMap;
    private static final long TIMESTAMP_RANGE = 3540000L;

    public APIConfiguration(String appKey, String appSecret, int localizeOption) {
        if (appKey == null) {
            throw new IllegalArgumentException("appKey is required!");
        }
        if (appSecret == null) {
            throw new IllegalArgumentException("appSecret is required!");
        }
        this.initLocalization(localizeOption);
        this.mSdkType = "java";
        this.mAppKey = appKey;
        this.mAppSecret = appSecret;
        this.mTimestampMap = new HashMap<String, Long>();
        this.mSignatureMap = new HashMap<String, String>();
    }

    public void setSdkType(String type) {
        this.mSdkType = type.toLowerCase();
    }

    public void setApiServerDomain(String domain) {
        this.mApiDomainName = domain;
    }

    public String getSdkType() {
        return this.mSdkType;
    }

    public String getAppKey() {
        return this.mAppKey;
    }

    public String getAppSecret() {
        return this.mAppSecret;
    }

    public int getLocalizeOption() {
        return this.mLocalizeOption;
    }

    public long getTimestamp(String apiName) {
        return this.mTimestampMap.get(apiName);
    }

    public String getSignature(String apiName) {
        return this.mSignatureMap.get(apiName);
    }

    public String getBaseRequestURL(String apiName) throws NoSuchAlgorithmException {
        return this.getBaseRequestURL(apiName, null);
    }

    public String getBaseRequestURL(String apiName, Map<String, String> queryParams) throws NoSuchAlgorithmException {
        this.generateSignature(apiName);
        StringBuffer urlStringBuffer = new StringBuffer();
        urlStringBuffer.append(this.mApiDomainName);
        urlStringBuffer.append(API_BASE_URL);
        urlStringBuffer.append("?_from=");
        urlStringBuffer.append(this.mSdkType);
        urlStringBuffer.append("&appkey=");
        urlStringBuffer.append(this.mAppKey);
        urlStringBuffer.append("&api=");
        urlStringBuffer.append(apiName);
        urlStringBuffer.append("&timestamp=");
        urlStringBuffer.append(this.getTimestamp(apiName));
        urlStringBuffer.append("&sign=");
        urlStringBuffer.append(this.getSignature(apiName));
        if (queryParams != null) {
            for (String key : queryParams.keySet()) {
                urlStringBuffer.append("&");
                urlStringBuffer.append(key.toString());
                urlStringBuffer.append("=");
                urlStringBuffer.append(queryParams.get(key));
            }
        }
        return urlStringBuffer.toString();
    }

    protected void generateSignature(String apiName) throws NoSuchAlgorithmException {
        long current = System.currentTimeMillis();
        long expired = 0L;
        if (!this.mTimestampMap.containsKey(apiName)) {
            this.mTimestampMap.put(apiName, current);
        }
        if (current > (expired = this.mTimestampMap.get(apiName) + 3540000L) || !this.mSignatureMap.containsKey(apiName)) {
            this.mTimestampMap.put(apiName, current);
            StringBuffer signStringBuffer = new StringBuffer();
            signStringBuffer.append(this.mAppSecret);
            signStringBuffer.append("api=");
            signStringBuffer.append(apiName);
            signStringBuffer.append("appkey=");
            signStringBuffer.append(this.mAppKey);
            signStringBuffer.append("timestamp=");
            signStringBuffer.append(this.mTimestampMap.get(apiName));
            signStringBuffer.append(this.mAppSecret);
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(signStringBuffer.toString().getBytes());
            StringBuffer signature = new StringBuffer();
            signature.append(new BigInteger(1, md.digest()).toString(16));
            if (signature.toString().length() < 32) {
                signature.insert(0, "0");
            }
            this.mSignatureMap.put(apiName, signature.toString());
        }
    }

    protected void initLocalization(int localizeOption) {
        switch (localizeOption) {
            case 0: {
                this.mApiDomainName = API_DOMAIN_NAME_CN;
                break;
            }
            case 1: {
                this.mApiDomainName = API_DOMAIN_NAME_TW;
                break;
            }
            default: {
                throw new IllegalArgumentException("Illegal localizeation option.");
            }
        }
        this.mLocalizeOption = localizeOption;
    }
}

