/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.cloudService;

import ai.olami.cloudService.APIConfiguration;
import java.util.UUID;

public abstract class APIRequestBase {
    private APIConfiguration mConfiguration = null;
    private String mCusId = "Undefined";
    private int mConnectionTimeoutMilliseconds = 5000;

    public APIRequestBase(APIConfiguration configuration) {
        this.mConfiguration = configuration;
        this.mCusId = UUID.randomUUID().toString();
    }

    public void setConfiguration(APIConfiguration configuration) {
        this.mConfiguration = configuration;
    }

    public APIConfiguration getConfiguration() {
        return this.mConfiguration;
    }

    public void setSdkType(String type) {
        if (this.mConfiguration != null) {
            this.mConfiguration.setSdkType(type);
        }
    }

    public String getSdkType() {
        if (this.mConfiguration != null) {
            return this.mConfiguration.getSdkType();
        }
        return "";
    }

    public void setEndUserIdentifier(String cusId) {
        this.mCusId = cusId;
    }

    public String getEndUserIdentifier() {
        return this.mCusId;
    }

    public int getTimeout() {
        return this.mConnectionTimeoutMilliseconds;
    }

    public void setTimeout(int milliseconds) {
        this.mConnectionTimeoutMilliseconds = milliseconds;
    }
}

