/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.cloudService;

import ai.olami.cloudService.APIResponseData;
import ai.olami.util.GsonFactory;
import com.google.gson.Gson;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class APIResponse {
    public static final String STATUS_OK = "ok";
    public static final String STATUS_ERROR = "error";
    public static final int ERROR_CODE_INVALID_CONTENT = -1000000;
    @Expose(serialize=false, deserialize=false)
    @SerializedName(value="original_json_string_for_debug")
    private String mSourceJsonString = null;
    @Expose(serialize=false, deserialize=false)
    private Gson mGson = GsonFactory.getNormalGson();
    @Expose
    @SerializedName(value="status")
    private String mStatus = "ok";
    @Expose
    @SerializedName(value="code")
    private int mCode;
    @Expose
    @SerializedName(value="msg")
    private String mMessage;
    @Expose
    @SerializedName(value="data")
    private APIResponseData mResponseData = null;

    public String toString() {
        if (this.mSourceJsonString == null) {
            return this.mGson.toJson((Object)this);
        }
        return this.mSourceJsonString;
    }

    public void setJsonStringSource(String jsonString) {
        this.mSourceJsonString = jsonString;
    }

    public void setInvalid(String message) {
        this.setError(-1000000, message);
    }

    public void setError(int errorCode, String errorMessage) {
        this.setStatus(STATUS_ERROR);
        this.setErrorCode(errorCode);
        this.setErrorMessage(errorMessage);
    }

    public boolean ok() {
        return this.getStatus().equals(STATUS_OK);
    }

    public boolean hasError() {
        return !this.ok();
    }

    public String getStatus() {
        return this.mStatus;
    }

    public void setStatus(String status) {
        this.mStatus = status;
    }

    public int getErrorCode() {
        return this.mCode;
    }

    public void setErrorCode(int errorEode) {
        this.mCode = errorEode;
    }

    public String getErrorMessage() {
        return this.mMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.mMessage = errorMessage;
    }

    public APIResponseData getData() {
        return this.mResponseData;
    }

    public boolean hasData() {
        return this.mResponseData != null;
    }
}

