/*
 * Decompiled with CFR 0.152.
 */
package ai.olami.cloudService;

import ai.olami.cloudService.APIConfiguration;
import ai.olami.cloudService.APIRequestBase;
import ai.olami.cloudService.APIResponse;
import ai.olami.cloudService.APIResponseBuilder;
import ai.olami.cloudService.CookieSet;
import ai.olami.cloudService.NLIConfig;
import ai.olami.util.GsonFactory;
import ai.olami.util.HttpClient;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import org.xiph.speex.SpeexEncoder;

public class SpeechRecognizer
extends APIRequestBase {
    public static final int AUDIO_TYPE_PCM_RAW = 0;
    public static final int AUDIO_TYPE_PCM_WAVE = 1;
    public static final int AUDIO_TYPE_PCM_SPEEX = 2;
    public static final int AUDIO_LENGTH_MILLISECONDS_PER_FRAME = 10;
    public static final int AUDIO_SAMPLE_RATE = 16000;
    public static final int AUDIO_BITS_PER_SAMPLE = 16;
    public static final int AUDIO_CHANNELS = 1;
    private static final String SEQ_TYPE_SEG = "seg";
    private static final String SEQ_TYPE_NLI = "nli";
    private static final String SEQ_TYPE_ALL = "nli,seg";
    private static final int WAVE_HEADER_SIZE = 44;
    private static final int AUDIO_FRAME_SIZE = 320;
    private static final String EXMSG_AUDIO_TYPE_NOT_SET = "Audio type has not been set! You must to specify the audio type by setAudioType(int audioType) before doing this.";
    private static final String EXMSG_INVALID_AUDIO_TYPE = "Invalid audio type!";
    private static final String EXMSG_MUST_BE_SPECIFIED_METHOD = "Not support this audio type!";
    private String mApiName = "asr";
    private String mDefaultSeqType = "seg";
    private int mAudioType = -1;
    private boolean mEncodeToSpeex = true;
    private SpeexEncoder mSpeexEncoder = null;
    private int mSpeexProcessFrames = 2;
    private int mSpeexProcessSize = 0;
    private int mAudioBufferListMaxSize = 0;
    private int mAudioBufferListMinSize = 0;
    private int mAudioBufferListCurrentSize = 0;
    private int mAudioBufferListAppendedSize = 0;
    private LinkedList<byte[]> mAudioBufferList = new LinkedList();
    private Gson mGson = GsonFactory.getNormalGson();

    public SpeechRecognizer(APIConfiguration configuration) {
        super(configuration);
        if (this.mEncodeToSpeex) {
            this.initSpeexEncoder();
        }
        this.mAudioBufferListMinSize = this.mSpeexProcessFrames * this.getAudioFrameSize();
        this.mAudioBufferListMaxSize = 3000 * this.getAudioFrameSize();
    }

    public int getAudioFrameSize() {
        if (this.mEncodeToSpeex && this.mSpeexEncoder != null) {
            return this.mSpeexEncoder.getFrameSize();
        }
        return 320;
    }

    public APIResponse uploadAudio(CookieSet identifier, String filePath, boolean isFinalAudio) throws IOException, NoSuchAlgorithmException {
        if (this.mAudioType == -1) {
            throw new UnsupportedOperationException(EXMSG_AUDIO_TYPE_NOT_SET);
        }
        return this.uploadAudio(identifier, filePath, this.mAudioType, isFinalAudio);
    }

    public APIResponse uploadAudio(CookieSet identifier, String filePath, int audioType, boolean isFinalAudio) throws IOException, NoSuchAlgorithmException {
        File file = new File(filePath);
        if (file == null || !file.exists()) {
            throw new FileNotFoundException("File not found: " + filePath);
        }
        FileInputStream fileIn = new FileInputStream(file);
        byte[] fileData = new byte[(int)file.length()];
        fileIn.read(fileData);
        fileIn.close();
        return this.uploadAudio(identifier, fileData, audioType, isFinalAudio);
    }

    public APIResponse uploadAudio(CookieSet identifier, byte[] audioData, boolean isFinalAudio) throws IOException, NoSuchAlgorithmException {
        if (this.mAudioType == -1) {
            throw new UnsupportedOperationException(EXMSG_AUDIO_TYPE_NOT_SET);
        }
        return this.uploadAudio(identifier, audioData, this.mAudioType, isFinalAudio);
    }

    public APIResponse uploadAudio(CookieSet identifier, byte[] audioData, int audioType, boolean isFinalAudio) throws IOException, NoSuchAlgorithmException {
        byte[] audioBuffer = null;
        int audioSize = audioData.length;
        switch (audioType) {
            case 0: {
                if (this.mEncodeToSpeex) {
                    audioBuffer = audioData;
                    audioSize = this.speexEncodeRawWavePCM(audioBuffer);
                    break;
                }
                if (this.containsWaveHeader(audioData)) break;
                audioBuffer = this.getWithWaveHeader(audioData, false);
                audioSize = audioBuffer.length;
                break;
            }
            case 1: {
                if (!this.mEncodeToSpeex) break;
                if (this.containsWaveHeader(audioData)) {
                    audioBuffer = this.getWithoutWaveHeader(audioData, false);
                }
                audioSize = this.speexEncodeRawWavePCM(audioBuffer);
                break;
            }
            case 2: {
                throw new UnsupportedOperationException("Not support this audio type!\nYou should use ** uploadSpeexAudio() ** method instead");
            }
            default: {
                throw new IllegalArgumentException(EXMSG_INVALID_AUDIO_TYPE);
            }
        }
        return this.uploadAudioData(identifier, audioBuffer, audioSize, isFinalAudio);
    }

    public APIResponse uploadSpeexAudio(CookieSet identifier, byte[] audioData, int audioDataRealSize, boolean isFinalAudio) throws IOException, NoSuchAlgorithmException {
        if (this.mAudioType != 2) {
            throw new IllegalArgumentException("Invalid audio type!\nOnly supports ** SPEEX ** audio data.");
        }
        return this.uploadAudioData(identifier, audioData, audioDataRealSize, isFinalAudio);
    }

    public void setAudioType(int audioType) {
        switch (audioType) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(EXMSG_INVALID_AUDIO_TYPE);
            }
        }
        this.mAudioType = audioType;
    }

    public int getAudioBufferMaxSize() {
        return this.mAudioBufferListMaxSize;
    }

    public int getAudioBufferMinSize() {
        return this.mAudioBufferListMinSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendAudioFramesData(byte[] audioFramesData) {
        if (this.mAudioType == -1) {
            throw new UnsupportedOperationException(EXMSG_AUDIO_TYPE_NOT_SET);
        }
        if (this.mAudioType == 2) {
            throw new UnsupportedOperationException("Not support this audio type!\nYou should use ** appendSpeexAudioFramesData() ** method instead");
        }
        if (this.mAudioBufferListAppendedSize > this.mAudioBufferListMaxSize) {
            throw new IllegalStateException("The total size of append buffers is greater than the limited size (" + this.mAudioBufferListMaxSize + "). You have to flush for upload.");
        }
        LinkedList<byte[]> linkedList = this.mAudioBufferList;
        synchronized (linkedList) {
            int audioSize = audioFramesData.length;
            byte[] tempData = new byte[audioSize];
            System.arraycopy(audioFramesData, 0, tempData, 0, audioSize);
            if (this.mEncodeToSpeex) {
                if (audioSize < this.mAudioBufferListMinSize || audioSize % this.mSpeexProcessSize != 0) {
                    throw new IllegalArgumentException("The size of input data must be greater than " + this.mAudioBufferListMinSize + " (Bytes), and it must be a multiple of " + this.mSpeexProcessSize + " (Bytes).");
                }
                audioSize = this.speexEncodeRawWavePCM(tempData);
            }
            byte[] appendData = new byte[audioSize];
            System.arraycopy(tempData, 0, appendData, 0, audioSize);
            Arrays.fill(tempData, (byte)0);
            this.mAudioBufferList.offer(appendData);
            this.mAudioBufferListCurrentSize += audioSize;
            this.mAudioBufferListAppendedSize += audioFramesData.length;
        }
        return this.mAudioBufferListAppendedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int appendSpeexAudioFramesData(byte[] audioFramesData, int audioDataRealSize) {
        if (this.mAudioType != 2) {
            throw new IllegalArgumentException("Invalid audio type!\nOnly supports ** SPEEX ** audio data.");
        }
        if (this.mAudioBufferListAppendedSize > this.mAudioBufferListMaxSize) {
            throw new IllegalStateException("The total size of append buffers is greater than the limited size (" + this.mAudioBufferListMaxSize + "). You have to flush for upload.");
        }
        LinkedList<byte[]> linkedList = this.mAudioBufferList;
        synchronized (linkedList) {
            byte[] appendData = new byte[audioDataRealSize];
            System.arraycopy(audioFramesData, 0, appendData, 0, audioDataRealSize);
            this.mAudioBufferList.offer(appendData);
            this.mAudioBufferListCurrentSize += audioDataRealSize;
            this.mAudioBufferListAppendedSize += audioDataRealSize;
        }
        return this.mAudioBufferListAppendedSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public APIResponse flushToUploadAudio(CookieSet identifier, boolean isFinalAudio) throws IOException, NoSuchAlgorithmException {
        if (this.mAudioType == -1) {
            throw new UnsupportedOperationException(EXMSG_AUDIO_TYPE_NOT_SET);
        }
        byte[] buffer = null;
        LinkedList<byte[]> linkedList = this.mAudioBufferList;
        synchronized (linkedList) {
            if (this.mAudioBufferList.size() == 0) {
                throw new IllegalStateException("There are no appended buffers.");
            }
            buffer = new byte[this.mAudioBufferListCurrentSize];
            byte[] data = null;
            int currentPos = 0;
            while ((data = this.mAudioBufferList.poll()) != null) {
                System.arraycopy(data, 0, buffer, currentPos, data.length);
                currentPos += data.length;
            }
            this.mAudioBufferListCurrentSize = 0;
            this.mAudioBufferListAppendedSize = 0;
        }
        if (!this.mEncodeToSpeex && this.mAudioType != 2) {
            if (this.containsWaveHeader(buffer)) {
                buffer = this.getWithoutWaveHeader(buffer, true);
            }
            buffer = this.getWithWaveHeader(buffer, true);
        }
        return this.uploadAudioData(identifier, buffer, buffer.length, isFinalAudio);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAppendedAudio() {
        LinkedList<byte[]> linkedList = this.mAudioBufferList;
        synchronized (linkedList) {
            this.mAudioBufferList.clear();
            this.mAudioBufferListCurrentSize = 0;
            this.mAudioBufferListAppendedSize = 0;
        }
    }

    public int getAppendedAudioSize() {
        return this.mAudioBufferListAppendedSize;
    }

    public int getBufferedDataSize() {
        return this.mAudioBufferListCurrentSize;
    }

    public boolean hasBufferedData() {
        return !this.mAudioBufferList.isEmpty();
    }

    public APIResponse requestRecognition(CookieSet identifier) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        return this.sendGetResultsRequest(identifier, SEQ_TYPE_SEG, null);
    }

    public APIResponse requestRecognitionWithNLI(CookieSet identifier) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        return this.requestRecognitionWithNLI(identifier, null);
    }

    public APIResponse requestRecognitionWithNLI(CookieSet identifier, NLIConfig nliConfig) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        return this.sendGetResultsRequest(identifier, SEQ_TYPE_NLI, nliConfig);
    }

    public APIResponse requestRecognitionWithAll(CookieSet identifier) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        return this.requestRecognitionWithAll(identifier, null);
    }

    public APIResponse requestRecognitionWithAll(CookieSet identifier, NLIConfig nliConfig) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        return this.sendGetResultsRequest(identifier, SEQ_TYPE_ALL, nliConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIResponse uploadAudioData(CookieSet identifier, byte[] audioData, int audioSize, boolean isFinalAudio) throws IOException, NoSuchAlgorithmException {
        String response;
        block6: {
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("compress", this.mEncodeToSpeex ? "1" : (this.mAudioType == 2 ? "1" : "0"));
            queryParams.put("seq", this.mDefaultSeqType);
            queryParams.put("stop", isFinalAudio ? "1" : "0");
            String cookies = identifier.getContents().toString();
            URL url = new URL(this.getConfiguration().getBaseRequestURL(this.mApiName, queryParams));
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setRequestMethod("POST");
            if (cookies != null && !cookies.equals("")) {
                httpConnection.setRequestProperty("Cookie", cookies);
            }
            httpConnection.setRequestProperty("contentType", "utf-8");
            httpConnection.setConnectTimeout(this.getTimeout());
            response = "";
            try (HttpClient httpClient = null;){
                httpClient = new HttpClient(httpConnection);
                httpClient.octetStreamConnect(audioData, audioSize);
                if (httpClient.getResponseCode() == 200) {
                    response = httpClient.getResponseContent();
                    identifier.setContents(httpClient.getCookies());
                    if (identifier.getContents() == null) {
                        throw new IOException("Failed to get cookie from server.");
                    }
                    break block6;
                }
                throw new IOException(httpClient.getResponseMessage());
            }
        }
        return APIResponseBuilder.create(response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private APIResponse sendGetResultsRequest(CookieSet identifier, String seqType, NLIConfig nliConfig) throws IllegalArgumentException, IOException, NoSuchAlgorithmException {
        String response;
        block6: {
            String cookies = identifier.getContents().toString();
            if (cookies == null) {
                throw new IllegalArgumentException("Invalid contents of the CookieSet.");
            }
            HashMap<String, String> queryParams = new HashMap<String, String>();
            queryParams.put("compress", this.mEncodeToSpeex ? "1" : "0");
            queryParams.put("seq", seqType);
            JsonObject rq = new JsonObject();
            if (seqType.contains(SEQ_TYPE_NLI) && nliConfig != null) {
                rq.add("nli_config", nliConfig.toJsonElement());
            }
            queryParams.put("rq", this.mGson.toJson((JsonElement)rq));
            URL url = new URL(this.getConfiguration().getBaseRequestURL(this.mApiName, queryParams));
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            httpConnection.setRequestMethod("GET");
            httpConnection.setRequestProperty("Cookie", cookies);
            httpConnection.setRequestProperty("contentType", "utf-8");
            httpConnection.setConnectTimeout(this.getTimeout());
            response = null;
            try (HttpClient httpClient = null;){
                httpClient = new HttpClient(httpConnection);
                httpClient.normalConnect();
                if (httpClient.getResponseCode() == 200) {
                    response = httpClient.getResponseContent();
                    break block6;
                }
                throw new IOException(httpClient.getResponseMessage());
            }
        }
        return APIResponseBuilder.create(response);
    }

    private void initSpeexEncoder() {
        int mode = 1;
        int quality = 10;
        if (this.mSpeexEncoder == null) {
            this.mSpeexEncoder = new SpeexEncoder();
            this.mSpeexEncoder.init(mode, quality, 16000, 1);
        }
        this.mSpeexProcessSize = this.mSpeexProcessFrames * 1 * this.mSpeexEncoder.getFrameSize();
    }

    private int speexEncodeRawWavePCM(byte[] audioData) {
        this.initSpeexEncoder();
        int blockSize = this.mSpeexProcessSize;
        byte[] data = new byte[blockSize];
        int encodeSize = 0;
        int encodedBytes = 0;
        int processedOffset = 0;
        while (processedOffset + blockSize <= audioData.length) {
            System.arraycopy(audioData, processedOffset, data, 0, blockSize);
            processedOffset += blockSize;
            this.mSpeexEncoder.processData(data, 0, this.mSpeexProcessSize);
            encodeSize = this.mSpeexEncoder.getProcessedData(data, 0);
            if (encodeSize > 0) {
                if (encodeSize > audioData.length) {
                    encodeSize = audioData.length;
                }
                System.arraycopy(data, 0, audioData, encodedBytes, encodeSize);
                encodedBytes += encodeSize;
            }
            Arrays.fill(data, (byte)0);
        }
        if (encodedBytes < audioData.length) {
            Arrays.fill(audioData, encodedBytes, audioData.length - 1, (byte)0);
        }
        return encodedBytes;
    }

    private boolean containsWaveHeader(byte[] audioData) {
        return audioData.length > 44 && audioData[0] == 82 && audioData[1] == 73 && audioData[2] == 70 && audioData[3] == 70 && audioData[8] == 87 && audioData[9] == 65 && audioData[10] == 86 && audioData[11] == 69;
    }

    private byte[] getWithoutWaveHeader(byte[] soureData, boolean cleanSourceData) {
        int newSize = soureData.length - 44;
        byte[] newData = new byte[newSize];
        System.arraycopy(soureData, 44, newData, 0, newSize);
        if (cleanSourceData) {
            Arrays.fill(soureData, (byte)0);
        }
        return newData;
    }

    private byte[] getWithWaveHeader(byte[] soureData, boolean cleanSourceData) {
        int audioDataSize = soureData.length;
        int totalLength = soureData.length;
        int byteRate = 32000;
        byte[] newData = new byte[audioDataSize + 44];
        newData[0] = 82;
        newData[1] = 73;
        newData[2] = 70;
        newData[3] = 70;
        newData[4] = (byte)(audioDataSize & 0xFF);
        newData[5] = (byte)(audioDataSize >> 8 & 0xFF);
        newData[6] = (byte)(audioDataSize >> 16 & 0xFF);
        newData[7] = (byte)(audioDataSize >> 24 & 0xFF);
        newData[8] = 87;
        newData[9] = 65;
        newData[10] = 86;
        newData[11] = 69;
        newData[12] = 102;
        newData[13] = 109;
        newData[14] = 116;
        newData[15] = 32;
        newData[16] = 16;
        newData[17] = 0;
        newData[18] = 0;
        newData[19] = 0;
        newData[20] = 1;
        newData[21] = 0;
        newData[22] = 1;
        newData[23] = 0;
        newData[24] = -128;
        newData[25] = 62;
        newData[26] = 0;
        newData[27] = 0;
        newData[28] = (byte)(byteRate & 0xFF);
        newData[29] = (byte)(byteRate >> 8 & 0xFF);
        newData[30] = (byte)(byteRate >> 16 & 0xFF);
        newData[31] = (byte)(byteRate >> 24 & 0xFF);
        newData[32] = 2;
        newData[33] = 0;
        newData[34] = 16;
        newData[35] = 0;
        newData[36] = 100;
        newData[37] = 97;
        newData[38] = 116;
        newData[39] = 97;
        newData[40] = (byte)(totalLength & 0xFF);
        newData[41] = (byte)(totalLength >> 8 & 0xFF);
        newData[42] = (byte)(totalLength >> 16 & 0xFF);
        newData[43] = (byte)(totalLength >> 24 & 0xFF);
        System.arraycopy(soureData, 0, newData, 44, audioDataSize);
        if (cleanSourceData) {
            Arrays.fill(soureData, (byte)0);
        }
        return newData;
    }
}

